<?php
/**
 * admin.php - v33.1 完美修正版
 * 1. 修复：侧边栏底部找回直接显示的联系方式 (zh_starry2026)
 * 2. 视觉：保留图表、AI全息舱、微拟物 UI
 * 3. 逻辑：保留所有 API 修复和授权验证逻辑
 */
session_start();
require 'db.php';

// --- 0. 核心 API 处理逻辑 (内置于本文件) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    $res = ['status'=>'error', 'msg'=>'操作失败'];
    
    try {
        $act = $_POST['action'];

        // 1. 授权验证 (逻辑优化版)
        if ($act === 'get_license_info') {
            $localKey = '未知';
            if (file_exists('license.lock')) {
                $content = trim(file_get_contents('license.lock'));
                if (preg_match('/KEY:\s*([^\s]+)/', $content, $m)) $localKey = trim($m[1]);
                else $localKey = $content;
            }
            if (empty($localKey) || $localKey=='未知') throw new Exception("本地未找到授权文件");

            $ch = curl_init("http://source.ictcode.com/api/query_license.php");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['key' => $localKey, 'domain' => $_SERVER['HTTP_HOST'], 'ip' => $_SERVER['REMOTE_ADDR']]));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 8);
            $resp = curl_exec($ch);
            $curlErr = curl_error($ch);
            curl_close($ch);
            
            if ($curlErr) {
                echo json_encode(['status'=>'error', 'msg'=>'连接超时: '.$curlErr, 'local_key'=>$localKey]); exit;
            }
            
            $json = json_decode($resp, true);
            if ($json && isset($json['status']) && $json['status'] === 'success') {
                $res = ['status'=>'success', 'data' => $json['data']];
            } else {
                echo json_encode(['status'=>'error', 'msg'=>$json['msg'] ?? '验证被拒绝', 'local_key'=>$localKey]); exit;
            }
        }
        
        // 2. 业务逻辑 (AI测试/积分/商城等)
        elseif ($act === 'test_ai') {
            $apiKey = $_POST['key'];
            if (empty($apiKey)) throw new Exception('API Key 不能为空');
            $ch = curl_init("https://api.siliconflow.cn/v1/chat/completions");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
                "model" => "Qwen/Qwen2.5-7B-Instruct", "messages" => [ ["role" => "user", "content" => "回复OK"] ], "stream" => false, "max_tokens" => 10
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $apiKey", "Content-Type: application/json"]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 8);
            $resp = curl_exec($ch);
            curl_close($ch);
            $json = json_decode($resp, true);
            if (isset($json['choices'][0]['message']['content'])) $res = ['status'=>'success', 'msg'=>'✅ 连接成功'];
            else throw new Exception($json['error']['message'] ?? '连接失败');
        }
        elseif ($act === 'update_points') {
            $conn->prepare("UPDATE users SET points = points + ? WHERE id = ?")->execute([(int)$_POST['amount'], (int)$_POST['uid']]);
            $res = ['status'=>'success', 'msg'=>'成功'];
        }
        elseif ($act === 'grant_title') {
            $stmt = $conn->prepare("INSERT INTO assets (name, type, value, style, price) VALUES (?, 'title', ?, ?, 0)");
            $stmt->execute([$_POST['title'], $_POST['title'], $_POST['style']]);
            $aid = $conn->lastInsertId();
            $conn->prepare("INSERT INTO user_assets (user_id, asset_id, is_equipped) VALUES (?, ?, 1)")->execute([(int)$_POST['uid'], $aid]);
            $conn->query("UPDATE user_assets ua JOIN assets a ON ua.asset_id=a.id SET ua.is_equipped=0 WHERE ua.user_id=".intval($_POST['uid'])." AND a.type='title' AND ua.asset_id != $aid");
            $res = ['status'=>'success', 'msg'=>'成功'];
        }
        elseif ($act === 'add_asset') {
            $stmt = $conn->prepare("INSERT INTO assets (name, type, value, style, price) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$_POST['name'], $_POST['type'], $_POST['value'], $_POST['style'], (int)$_POST['price']]);
            $res = ['status'=>'success', 'msg'=>'已上架'];
        }
        elseif ($act === 'del_asset') {
            $conn->prepare("DELETE FROM assets WHERE id=?")->execute([(int)$_POST['id']]);
            $res = ['status'=>'success', 'msg'=>'已下架'];
        }
        elseif ($act === 'del_product') {
            $conn->prepare("DELETE FROM products WHERE id=?")->execute([(int)$_POST['id']]);
            $res = ['status'=>'success', 'msg'=>'商品已删除'];
        }
        elseif ($act === 'del_post') {
            $conn->prepare("DELETE FROM posts WHERE id=?")->execute([(int)$_POST['id']]);
            $res = ['status'=>'success', 'msg'=>'帖子已删除'];
        }
        elseif ($act === 'save_settings') {
            $stmt = $conn->prepare("INSERT INTO settings (config_key, config_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE config_value = VALUES(config_value)");
            foreach ($_POST as $k => $v) { if ($k != 'action') $stmt->execute([$k, $v]); }
            $res = ['status'=>'success', 'msg'=>'配置已保存'];
        }
        elseif ($act === 'change_license') {
            file_put_contents('license.lock', "KEY: ".trim($_POST['new_key']));
            $res = ['status'=>'success', 'msg'=>'Key已更新'];
        }
        elseif ($act === 'change_password') {
            $pass = password_hash($_POST['new_pass'], PASSWORD_DEFAULT);
            $conn->prepare("UPDATE admins SET password = ? WHERE username = ?")->execute([$pass, $_SESSION['admin_username'] ?? 'admin']);
            $res = ['status'=>'success', 'msg'=>'密码修改成功'];
        }

    } catch (Exception $e) { $res['msg'] = $e->getMessage(); }
    
    echo json_encode($res); exit;
}

if (!isset($_SESSION['admin_logged_in'])) { header("Location: admin_login.php"); exit; }

$version_file = 'version.php';
$current_version = file_exists($version_file) ? include $version_file : '33.1';
$admin_title = get_setting('admin_title', 'SLICE ADMIN');

try {
    $stats = [
        'users' => $conn->query("SELECT count(*) FROM users")->fetchColumn(),
        'posts' => $conn->query("SELECT count(*) FROM posts")->fetchColumn(),
        'products' => $conn->query("SELECT count(*) FROM products")->fetchColumn(),
        'income' => $conn->query("SELECT SUM(price) FROM products WHERE status=0")->fetchColumn() ?: 0
    ];
    if (!isset($_GET['tab']) || $_GET['tab'] == 'dashboard') {
        $chart_dates = []; $chart_posts = [];
        for ($i = 6; $i >= 0; $i--) {
            $d = date('Y-m-d', strtotime("-$i days"));
            $chart_dates[] = date('m-d', strtotime($d));
            $chart_posts[] = $conn->query("SELECT count(*) FROM posts WHERE DATE(created_at) = '$d'")->fetchColumn();
        }
        $pie_selling = $conn->query("SELECT count(*) FROM products WHERE status=1")->fetchColumn();
        $pie_sold = $conn->query("SELECT count(*) FROM products WHERE status=0")->fetchColumn();
    }
} catch (Exception $e) { $stats = ['users'=>0,'posts'=>0,'products'=>0,'income'=>0]; }

$tab = $_GET['tab'] ?? 'dashboard';
$data = [];

try {
    if ($tab == 'users') $data = $conn->query("SELECT * FROM users ORDER BY last_active DESC LIMIT 30")->fetchAll(PDO::FETCH_ASSOC);
    elseif ($tab == 'content') $data = $conn->query("SELECT p.*, u.username, u.avatar FROM posts p LEFT JOIN users u ON p.user_id = u.id ORDER BY p.id DESC LIMIT 30")->fetchAll(PDO::FETCH_ASSOC);
    elseif ($tab == 'products') $data = $conn->query("SELECT p.*, u.username, u.avatar FROM products p LEFT JOIN users u ON p.user_id = u.id ORDER BY p.id DESC LIMIT 30")->fetchAll(PDO::FETCH_ASSOC);
    elseif ($tab == 'mall') $data = $conn->query("SELECT * FROM assets ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
} catch(Exception $e) { $data = []; }
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($admin_title) ?> | 控制台</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root { --primary: #6366f1; --primary-gradient: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%); --bg-body: #f4f5f9; --text-main: #1f2937; --text-sub: #6b7280; --sidebar-bg: #0f172a; --card-bg: #ffffff; --border: #e2e8f0; --font-stack: "PingFang SC", "Microsoft YaHei", sans-serif; }
        * { box-sizing: border-box; outline: none; }
        body { margin:0; display:flex; height:100vh; font-family: var(--font-stack); background:var(--bg-body); color:var(--text-main); overflow:hidden; }
        
        .sidebar { width:260px; background:var(--sidebar-bg); color:#fff; display:flex; flex-direction:column; flex-shrink:0; box-shadow: 4px 0 20px rgba(0,0,0,0.05); z-index: 10; }
        .logo { height:70px; display:flex; align-items:center; padding:0 28px; font-size:20px; font-weight:900; letter-spacing: 1px; background: rgba(255,255,255,0.03); border-bottom: 1px solid rgba(255,255,255,0.05); }
        .logo i { color: #8b5cf6; margin-right: 12px; }
        .menu { flex:1; padding:25px 15px; overflow-y:auto; }
        .menu-tit { font-size:12px; color:#94a3b8; font-weight:bold; margin:20px 15px 10px; opacity: 0.6; }
        .nav-item { display:flex; align-items:center; padding:12px 18px; color:#cbd5e1; text-decoration:none; border-radius:12px; margin-bottom:6px; font-size:14px; transition:0.3s; font-weight: 500; }
        .nav-item:hover { background:rgba(255,255,255,0.08); color:#fff; transform: translateX(3px); }
        .nav-item.active { background: var(--primary-gradient); color:#fff; box-shadow: 0 4px 15px rgba(99, 102, 241, 0.4); }
        .nav-item i { width:24px; margin-right:10px; text-align: center; }
        .sidebar-foot { padding:20px; border-top:1px solid rgba(255,255,255,0.05); background: rgba(0,0,0,0.2); }
        
        /* 🔥 修正：侧边栏联系方式样式 */
        .dev-info { font-size:12px; color:#94a3b8; margin-bottom:10px; display:flex; align-items:center; gap:5px; }
        .contact-btn { background:rgba(255,255,255,0.08); padding:10px; border-radius:10px; font-size:12px; display:flex; align-items:center; justify-content:center; gap:8px; cursor:pointer; color:#e2e8f0; border:1px solid rgba(255,255,255,0.1); transition:0.3s; }
        .contact-btn:hover { background:rgba(255,255,255,0.15); color:#fff; }

        .main { flex:1; display:flex; flex-direction:column; overflow:hidden; position: relative; }
        .header { height:70px; background:#fff; border-bottom:1px solid var(--border); display:flex; align-items:center; justify-content:space-between; padding:0 40px; }
        .pg-title { font-size:20px; font-weight:800; color: #1e293b; }
        .content { flex:1; padding:30px 40px; overflow-y:auto; scroll-behavior: smooth; }
        
        .card { background:#fff; border-radius:20px; border:1px solid #f1f5f9; box-shadow:0 4px 6px -1px rgba(0, 0, 0, 0.05); margin-bottom:25px; transition:0.2s; overflow:hidden; }
        .card:hover { transform:translateY(-2px); box-shadow:0 10px 25px -5px rgba(0,0,0,0.05); }
        .card-head { padding:20px 25px; border-bottom:1px solid #f8fafc; display:flex; justify-content:space-between; align-items:center; font-weight:700; font-size: 16px; color: #334155; background: linear-gradient(to bottom, #fff, #fcfcfd); }
        .card-body { padding:25px; }

        .grid-4 { display:grid; grid-template-columns:repeat(auto-fit, minmax(260px, 1fr)); gap:25px; margin-bottom:30px; }
        .stat-card { padding:25px; background:#fff; border-radius:20px; border:1px solid #f1f5f9; position: relative; overflow: hidden; }
        .stat-icon { width:54px; height:54px; border-radius:14px; display:flex; align-items:center; justify-content:center; font-size:24px; margin-bottom:15px; box-shadow: 0 4px 10px rgba(0,0,0,0.05); }
        .stat-num { font-size: 32px; font-weight: 800; color: #0f172a; margin: 5px 0; }
        .stat-desc { font-size: 13px; color: #64748b; }
        
        .ai-status-box { background: #1e1b4b; color: #fff; border-radius: 16px; padding: 25px; display: flex; align-items: center; gap: 20px; position: relative; overflow: hidden; box-shadow: 0 10px 30px rgba(30, 27, 75, 0.5); }
        .ai-status-box::after { content: ''; position: absolute; top: -50%; right: -20%; width: 300px; height: 300px; background: radial-gradient(circle, rgba(99,102,241,0.4) 0%, transparent 70%); pointer-events: none; }
        .ai-avatar { width: 70px; height: 70px; border-radius: 50%; border: 3px solid rgba(255,255,255,0.2); box-shadow: 0 0 20px rgba(99,102,241,0.6); }
        .status-dot { display: inline-block; width: 8px; height: 8px; border-radius: 50%; background: #22c55e; margin-right: 6px; box-shadow: 0 0 8px #22c55e; animation: blink 2s infinite; }
        @keyframes blink { 0%,100%{opacity:1} 50%{opacity:0.4} }

        .switch-row { display:flex; align-items:center; gap:15px; padding:15px 20px; background:#f8fafc; border-radius:12px; border:1px solid #e2e8f0; margin-bottom: 12px; }
        .tgl { position: relative; display: inline-block; width: 44px; height: 24px; flex-shrink: 0; }
        .tgl input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #cbd5e1; transition: .4s; border-radius: 34px; }
        .slider:before { position: absolute; content: ""; height: 20px; width: 20px; left: 2px; bottom: 2px; background-color: white; transition: .4s; border-radius: 50%; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        input:checked + .slider { background-color: var(--primary); }
        input:checked + .slider:before { transform: translateX(20px); }

        .form-label { display:block; margin-bottom:8px; font-size:13px; font-weight:700; color:#475569; }
        .inp { width:100%; padding:12px 15px; border:1px solid #e2e8f0; border-radius:10px; background:#fff; font-size:14px; transition:0.2s; color: #1e293b; font-family: var(--font-stack); }
        .inp:focus { border-color:var(--primary); box-shadow: 0 0 0 3px rgba(99,102,241,0.1); }
        .btn { padding:12px 24px; border-radius:12px; font-weight:700; font-size:14px; cursor:pointer; border:none; transition:0.2s; display: inline-flex; align-items: center; justify-content: center; gap: 6px; }
        .btn-primary { background:var(--primary-gradient); color:#fff; }
        .btn-green { background: linear-gradient(135deg, #10b981 0%, #059669 100%); color:#fff; }
        .btn-sm { padding:6px 12px; font-size:12px; border-radius:8px; }
        
        table { width:100%; border-collapse:separate; border-spacing: 0; }
        th { text-align:left; padding:15px 25px; background:#f8fafc; color:#64748b; font-size:12px; font-weight: 700; border-bottom: 1px solid #e2e8f0; }
        td { padding:18px 25px; border-bottom:1px solid #f1f5f9; font-size:14px; vertical-align:middle; color: #334155; }
        tr:last-child td { border-bottom: none; }
        tr:hover td { background: #f8fafc; }
        .user-cell { display:flex; align-items:center; gap:12px; font-weight: 600; }
        .avatar-sm { width:36px; height:36px; border-radius:50%; background:#e2e8f0; object-fit:cover; border: 2px solid #fff; }
        .badge { padding:4px 10px; border-radius:6px; font-size:12px; font-weight:700; border:none; cursor: pointer; color:#fff; margin-right:5px; }
        .b-red { background:#fee2e2; color:#b91c1c; } .b-blue { background:#e0e7ff; color:#4338ca; } .b-green { background:#dcfce7; color:#166534; } .b-orange { background:#ffedd5; color:#c2410c; }

        .modal { display:none; position:fixed; inset:0; background:rgba(15, 23, 42, 0.6); z-index:1000; align-items:center; justify-content:center; backdrop-filter:blur(8px); }
        .modal-box { background:#fff; width:90%; max-width:480px; border-radius:24px; padding:35px; box-shadow:0 25px 60px -12px rgba(0,0,0,0.3); animation: popIn 0.3s cubic-bezier(0.34, 1.56, 0.64, 1); }
        @keyframes popIn { from{transform:scale(0.9);opacity:0} to{transform:scale(1);opacity:1} }
        
        .lic-card { background: linear-gradient(135deg, #1e1e2d 0%, #2b2b40 100%); color: #fff; padding: 30px; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.15); }
        .lic-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:25px; border-bottom:1px solid rgba(255,255,255,0.1); padding-bottom:15px; }
        .lic-grid { display:grid; grid-template-columns: 1fr 1fr; gap:20px; }
        .lic-item { background:rgba(255,255,255,0.08); padding:15px; border-radius:12px; }
        .lic-label { font-size:12px; opacity:0.6; margin-bottom:5px; }
        .lic-val { font-size:15px; font-weight:bold; }
    </style>
</head>
<body>

<div class="sidebar">
    <div class="logo"><i class="fa-solid fa-cube"></i> SLICE ADMIN</div>
    <div class="menu">
        <div class="menu-tit">DATA</div>
        <a href="?tab=dashboard" class="nav-item <?= $tab=='dashboard'?'active':'' ?>"><i class="fa-solid fa-chart-pie"></i> 仪表盘</a>
        <div class="menu-tit">MANAGE</div>
        <a href="?tab=products" class="nav-item <?= $tab=='products'?'active':'' ?>"><i class="fa-solid fa-store"></i> 闲置交易</a>
        <a href="?tab=mall" class="nav-item <?= $tab=='mall'?'active':'' ?>"><i class="fa-solid fa-gem"></i> 素材商城</a>
        <a href="?tab=users" class="nav-item <?= $tab=='users'?'active':'' ?>"><i class="fa-solid fa-users"></i> 用户管理</a>
        <a href="?tab=content" class="nav-item <?= $tab=='content'?'active':'' ?>"><i class="fa-solid fa-file-shield"></i> 内容审核</a>
        <div class="menu-tit">SYSTEM</div>
        <a href="?tab=ai" class="nav-item <?= $tab=='ai'?'active':'' ?>"><i class="fa-solid fa-robot"></i> AI 智能体</a>
        <a href="?tab=settings" class="nav-item <?= $tab=='settings'?'active':'' ?>"><i class="fa-solid fa-sliders"></i> 全局配置</a>
        <a href="?tab=license" class="nav-item <?= $tab=='license'?'active':'' ?>"><i class="fa-solid fa-certificate"></i> 授权中心</a>
    </div>
    <div class="sidebar-foot">
        <div class="dev-info"><i class="fa-brands fa-weixin"></i> 技术支持: zh_starry2026</div>
        <div class="contact-btn" onclick="document.getElementById('supportModal').style.display='flex'">获取详细联系卡片</div>
        <div style="text-align:center; color:#64748b; font-size:11px; margin-top:10px; font-weight:600;">System v<?= $current_version ?></div>
    </div>
</div>

<div class="main">
    <div class="header">
        <div class="pg-title"><?php $t=['dashboard'=>'数据仪表盘','ai'=>'AI 智能体配置','mall'=>'素材商城管理','users'=>'用户池管理','license'=>'商业授权中心','settings'=>'全局系统配置','content'=>'内容审核','products'=>'闲置商品']; echo $t[$tab]??'控制台'; ?></div>
        <a href="index.php" target="_blank" class="btn" style="background:#f1f5f9; color:#334155; box-shadow:none;"><i class="fa-solid fa-external-link-alt"></i> 前台</a>
    </div>

    <div class="content">
        <?php if($tab == 'dashboard'): ?>
        <div class="grid-4">
            <div class="stat-card"><div class="stat-icon" style="background:#eff6ff;color:#3b82f6"><i class="fa-solid fa-users"></i></div><div class="stat-num"><?= $stats['users'] ?></div><div class="stat-desc">用户总数</div></div>
            <div class="stat-card"><div class="stat-icon" style="background:#f0fdf4;color:#22c55e"><i class="fa-solid fa-yen-sign"></i></div><div class="stat-num"><?= number_format($stats['income'],2) ?></div><div class="stat-desc">交易额</div></div>
            <div class="stat-card"><div class="stat-icon" style="background:#faf5ff;color:#a855f7"><i class="fa-solid fa-fire"></i></div><div class="stat-num"><?= $stats['posts'] ?></div><div class="stat-desc">帖子数</div></div>
            <div class="stat-card"><div class="stat-icon" style="background:#fff7ed;color:#f97316"><i class="fa-solid fa-box"></i></div><div class="stat-num"><?= $stats['products'] ?></div><div class="stat-desc">商品数</div></div>
        </div>
        <div class="grid-4" style="grid-template-columns:2fr 1fr">
            <div class="card"><div class="card-head">活跃趋势</div><div class="card-body"><canvas id="trendChart" height="250"></canvas></div></div>
            <div class="card"><div class="card-head">商品分布</div><div class="card-body"><canvas id="pieChart" height="250"></canvas></div></div>
        </div>
        <?php endif; ?>

        <?php if($tab == 'license'): ?>
        <div style="max-width:800px; margin:0 auto;" id="licInfo">
            <div class="card" style="text-align:center;padding:60px"><i class="fa-solid fa-circle-notch fa-spin" style="font-size:30px;color:var(--primary)"></i><p style="margin-top:20px;color:#64748b">正在连接授权服务器...</p></div>
        </div>
        <script>
            window.addEventListener('load', ()=>{
                api({action:'get_license_info'}, res => {
                    if(res.status==='success'){
                        const d = res.data;
                        document.getElementById('licInfo').innerHTML = `<div class="lic-card"><div class="lic-header"><div style="display:flex;align-items:center;gap:10px;"><i class="fa-solid fa-shield-halved" style="font-size:24px;color:#ffd700;"></i><div><div style="font-weight:800;font-size:18px;">商业授权证书</div><div style="font-size:11px;opacity:0.6;letter-spacing:1px;">OFFICIAL LICENSE</div></div></div><span class="lic-badge">PRO EDITION</span></div><div class="lic-grid"><div class="lic-item"><div class="lic-label">授权域名</div><div class="lic-val">${d.domain||'未知'}</div></div><div class="lic-item"><div class="lic-label">授权类型</div><div class="lic-val" style="color:#ffd700">${d.type_text||'正式版'}</div></div><div class="lic-item"><div class="lic-label">到期时间</div><div class="lic-val">${d.expire_date||'永久'}</div></div><div class="lic-item"><div class="lic-label">状态</div><div class="lic-val" style="color:#4ade80">● 正常激活</div></div></div></div>`;
                    } else {
                        const k = res.local_key || '未找到';
                        document.getElementById('licInfo').innerHTML = `<div class="card"><div style="text-align:center;padding:40px;"><i class="fa-solid fa-circle-exclamation" style="font-size:40px;color:#ef4444"></i><h3>状态异常</h3><p style="color:#64748b;margin:15px 0">${res.msg}</p><div style="background:#f8fafc;padding:15px;border-radius:8px;margin-bottom:20px;font-family:monospace;color:#333;word-break:break-all">当前 Key: ${k}</div><button class="btn btn-primary" onclick="document.getElementById('changeLicModal').style.display='flex'">更换 Key</button></div></div>`;
                    }
                });
            });
        </script>
        <?php endif; ?>

        <?php if($tab == 'settings'): ?>
        <div class="grid-4" style="grid-template-columns: 1fr 1fr;">
            <div class="card">
                <div class="card-head">基础设置</div>
                <div class="card-body">
                    <form id="setForm">
                        <input type="hidden" name="action" value="save_settings">
                        <div style="margin-bottom:20px"><label class="form-label">后台标题</label><input type="text" name="admin_title" class="inp" value="<?= htmlspecialchars($admin_title) ?>"></div>
                        <div style="margin-bottom:20px"><label class="form-label">网站名称</label><input type="text" name="site_name" class="inp" value="<?= htmlspecialchars(get_setting('site_name')) ?>"></div>
                        <div style="margin-bottom:20px"><label class="form-label">首页公告</label><textarea name="site_notice" class="inp" style="height:80px"><?= htmlspecialchars(get_setting('site_notice')) ?></textarea></div>
                        <button type="button" class="btn btn-primary" onclick="saveSet('setForm')">保存配置</button>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-head">安全管理</div>
                <div class="card-body">
                    <form id="pwdForm">
                        <input type="hidden" name="action" value="change_password">
                        <div style="margin-bottom:20px"><label class="form-label">新密码</label><input type="password" name="new_pass" class="inp"></div>
                        <button type="button" class="btn btn-red" onclick="changePwd()">修改管理员密码</button>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if($tab == 'users'): ?>
        <div class="card"><div class="card-head">用户列表</div><div style="overflow-x:auto;"><table><thead><tr><th>用户</th><th>积分</th><th>操作</th></tr></thead><tbody>
            <?php foreach($data as $r): ?><tr>
                <td><div class="user-cell"><img src="<?=$r['avatar']?:'https://ui-avatars.com/api/?name=U'?>" class="avatar-sm"> <?=htmlspecialchars($r['username'])?></div></td>
                <td style="color:#f59e0b;font-weight:bold"><?=$r['points']?></td>
                <td>
                    <button class="badge b-green" onclick="openPoints(<?=$r['id']?>,'<?=$r['username']?>')">充值</button> 
                    <button class="badge b-orange" onclick="openTitle(<?=$r['id']?>,'<?=$r['username']?>')">赠称号</button>
                </td>
            </tr><?php endforeach; ?>
        </tbody></table></div></div>
        <?php endif; ?>

        <?php if($tab == 'mall'): ?>
        <div class="card"><div class="card-head">素材商城 <button class="btn btn-sm btn-primary" onclick="document.getElementById('addAssetModal').style.display='flex'">+ 上架</button></div><div style="overflow-x:auto;"><table><thead><tr><th>类型</th><th>名称</th><th>价格</th><th>操作</th></tr></thead><tbody>
            <?php foreach($data as $r): ?><tr><td><?=$r['type']?></td><td><?=htmlspecialchars($r['name'])?></td><td style="color:#f59e0b"><?=$r['price']?></td><td><button class="badge b-red" onclick="delAsset(<?=$r['id']?>,this)">下架</button></td></tr><?php endforeach; ?>
        </tbody></table></div></div>
        <?php endif; ?>

        <?php if($tab == 'products'): ?><div class="card"><div class="card-head">闲置商品</div><div style="overflow-x:auto;"><table><thead><tr><th>商品</th><th>发布人</th><th>价格</th><th>操作</th></tr></thead><tbody><?php foreach($data as $r): ?><tr><td><?=htmlspecialchars($r['title']??'')?></td><td><?=htmlspecialchars($r['username']??'')?></td><td style="color:#f59e0b">¥<?=$r['price']??0?></td><td><button class="badge b-red" onclick="delItem('products',<?=$r['id']?>,this)">删除</button></td></tr><?php endforeach; ?></tbody></table></div></div><?php endif; ?>
        <?php if($tab == 'content'): ?><div class="card"><div class="card-head">帖子管理</div><div style="overflow-x:auto;"><table><thead><tr><th>内容</th><th>发布人</th><th>时间</th><th>操作</th></tr></thead><tbody><?php foreach($data as $r): ?><tr><td style="max-width:200px;overflow:hidden;white-space:nowrap"><?=htmlspecialchars(mb_substr($r['content']??'',0,30))?></td><td><?=htmlspecialchars($r['username']??'')?></td><td><?=date('m-d',strtotime($r['created_at']))?></td><td><button class="badge b-red" onclick="delItem('content',<?=$r['id']?>,this)">删除</button></td></tr><?php endforeach; ?></tbody></table></div></div><?php endif; ?>
        
        <?php if($tab == 'ai'): ?>
        <div class="grid-4" style="grid-template-columns:1fr 1fr"><div class="card"><div class="card-head">AI 参数</div><div class="card-body"><form id="aiForm"><input type="hidden" name="action" value="save_settings"><div style="margin-bottom:15px"><label class="form-label">API Key</label><input type="text" name="ai_api_key" id="apiKey" class="inp" value="<?= htmlspecialchars(get_setting('ai_api_key')) ?>"></div><div style="margin-bottom:15px"><label class="form-label">机器人ID</label><input type="text" name="ai_user_id" class="inp" value="<?= htmlspecialchars(get_setting('ai_user_id')) ?>"></div><div style="margin-bottom:15px"><label class="form-label">Prompt</label><textarea name="ai_persona" class="inp" style="height:80px"><?= htmlspecialchars(get_setting('ai_persona')) ?></textarea></div><div style="margin-bottom:15px"><label><input type="checkbox" name="ai_comment_open" value="1" <?= get_setting('ai_comment_open')==1?'checked':'' ?>> 开启自动评论</label> <label style="margin-left:10px"><input type="checkbox" name="ai_chat_open" value="1" <?= get_setting('ai_chat_open')==1?'checked':'' ?>> 开启私聊</label></div><button type="button" class="btn btn-primary" onclick="saveSet('aiForm')">保存</button> <button type="button" class="btn btn-green" onclick="testAI()">测试连接</button></form></div></div>
        <div style="display:flex; flex-direction:column; gap:25px;"><div class="ai-status-box"><img src="https://ui-avatars.com/api/?name=AI&background=ffffff&color=6366f1&size=128" class="ai-avatar"><div><h2 style="margin:0 0 5px 0; font-size:20px;">DeepSeek V3</h2><p style="margin:0; opacity:0.8; font-size:13px;">SiliconFlow API Drive</p><div style="margin-top:12px; font-size:12px; background:rgba(255,255,255,0.1); padding:4px 10px; border-radius:20px; display:inline-block;"><span class="status-dot"></span> 引擎待命</div></div></div></div>
        </div>
        <?php endif; ?>
    </div>
</div>

<div class="modal" id="changeLicModal" onclick="if(event.target===this)this.style.display='none'"><div class="modal-box"><h3>更换 Key</h3><input type="text" id="newKey" class="inp" placeholder="XYB-..." style="margin-bottom:20px;"><div style="text-align:right"><button class="btn btn-primary" onclick="doChangeLic()">确定</button></div></div></div>
<div class="modal" id="pointsModal" onclick="if(event.target===this)this.style.display='none'"><div class="modal-box"><h3>积分管理</h3><form id="ptForm"><input type="hidden" name="action" value="update_points"><input type="hidden" name="uid" id="pt-uid"><div style="margin-bottom:15px"><label class="form-label">用户</label><input type="text" id="pt-name" class="inp" disabled></div><div style="margin-bottom:20px"><label class="form-label">数量 (负数扣除)</label><input type="number" name="amount" class="inp" required></div><button type="button" class="btn btn-primary" style="width:100%" onclick="subPt()">提交</button></form></div></div>
<div class="modal" id="titleModal" onclick="if(event.target===this)this.style.display='none'"><div class="modal-box"><h3>赠送称号</h3><form id="tlForm"><input type="hidden" name="action" value="grant_title"><input type="hidden" name="uid" id="tl-uid"><div style="margin-bottom:15px"><label class="form-label">称号名</label><input type="text" name="title" class="inp" required></div><div style="margin-bottom:20px"><label class="form-label">CSS 样式</label><input type="text" name="style" class="inp" placeholder="background:gold; color:#000;"></div><button type="button" class="btn btn-primary" style="width:100%" onclick="subTl()">发放</button></form></div></div>
<div class="modal" id="addAssetModal" onclick="if(event.target===this)this.style.display='none'"><div class="modal-box"><h3>上架素材</h3><form id="asForm"><input type="hidden" name="action" value="add_asset"><div style="margin-bottom:10px"><label class="form-label">名称</label><input type="text" name="name" class="inp" required></div><div style="margin-bottom:10px"><label class="form-label">类型</label><select name="type" class="inp" style="margin-bottom:10px"><option value="title">称号</option><option value="bg">背景</option></select></div><div style="margin-bottom:10px"><label class="form-label">值</label><input type="text" name="value" class="inp" required style="margin-bottom:10px"></div><div style="margin-bottom:10px"><label class="form-label">样式</label><input type="text" name="style" class="inp" style="margin-bottom:10px"></div><div style="margin-bottom:20px"><label class="form-label">价格</label><input type="number" name="price" class="inp" required></div><button type="button" class="btn btn-primary" style="width:100%;margin-top:10px" onclick="subAs()">上架</button></form></div></div>
<div class="modal" id="supportModal" onclick="if(event.target===this)this.style.display='none'"><div class="support-card"><div class="sup-header"><div style="font-size:18px;font-weight:bold;">技术支持中心</div><div style="font-size:12px;opacity:0.8;">Slice System Official Support</div></div><div class="sup-body"><div class="wx-box"><span style="color:#6b7280;font-size:13px;">官方微信号</span><div style="display:flex;align-items:center;gap:10px;"><span class="wx-code">zh_starry2026</span><span class="copy-btn" onclick="navigator.clipboard.writeText('zh_starry2026');alert('已复制')">复制</span></div></div><button class="btn btn-primary" style="width:100%;" onclick="document.getElementById('supportModal').style.display='none'">关闭</button></div></div></div>

<script>
    <?php if($tab == 'dashboard'): ?>
    new Chart(document.getElementById('trendChart'),{type:'line',data:{labels:<?=json_encode($chart_dates)?>,datasets:[{label:'新增内容',data:<?=json_encode($chart_posts)?>,borderColor:'#6366f1',backgroundColor:'rgba(99,102,241,0.1)',fill:true}]},options:{responsive:true,maintainAspectRatio:false}});
    new Chart(document.getElementById('pieChart'),{type:'doughnut',data:{labels:['在售','已售'],datasets:[{data:[<?=$pie_selling?>,<?=$pie_sold?>],backgroundColor:['#6366f1','#e2e8f0']}]},options:{responsive:true,maintainAspectRatio:false}});
    <?php endif; ?>

    // 🔥 统一 API 接口
    function api(d, cb) {
        const f = new FormData();
        for(let k in d) f.append(k, d[k]);
        fetch('admin.php', {method:'POST', body:f}).then(r=>r.json()).then(cb).catch(e=>alert('Error: '+e));
    }
    
    function saveSet(fid){const f=document.getElementById(fid);const d={action:'save_settings'};new FormData(f).forEach((v,k)=>d[k]=v);api(d,r=>alert(r.msg));}
    function testAI(){const k=document.getElementById('apiKey').value;api({action:'test_ai',key:k},r=>alert(r.msg));}
    function doChangeLic(){const k=document.getElementById('newKey').value;api({action:'change_license',new_key:k},r=>{alert(r.msg);location.reload()});}
    function changePwd(){if(!confirm('确定?'))return;const f=document.getElementById('pwdForm');api({action:'change_password',new_pass:f.new_pass.value},r=>{alert(r.msg);if(r.status=='success')location.href='admin_login.php'});}

    // Modal Logic
    function openPoints(id,n){document.getElementById('pt-uid').value=id;document.getElementById('pt-name').value=n;document.getElementById('pointsModal').style.display='flex';}
    function subPt(){const f=document.getElementById('ptForm');const d={};new FormData(f).forEach((v,k)=>d[k]=v);api(d,r=>{alert(r.msg);location.reload()});}
    function openTitle(id,n){document.getElementById('tl-uid').value=id;document.getElementById('titleModal').style.display='flex';}
    function subTl(){const f=document.getElementById('tlForm');const d={};new FormData(f).forEach((v,k)=>d[k]=v);api(d,r=>{alert(r.msg);location.reload()});}
    function subAs(){const f=document.getElementById('asForm');const d={};new FormData(f).forEach((v,k)=>d[k]=v);api(d,r=>{alert(r.msg);location.reload()});}
    function delAsset(id,btn){if(confirm('下架?'))api({action:'del_asset',id:id},r=>{btn.closest('tr').remove()});}
    function delItem(t,id,btn){
        let act = t==='products'?'del_product':'del_post';
        if(confirm('删除?')) api({action:act,id:id},r=>{if(r.status=='success')btn.closest('tr').remove()});
    }
</script>
</body>
</html>