<?php
/**
 * admin_login.php - 智能自愈版
 * 特性：自动检测并修复缺失的 admins 表，无需手动跑 SQL
 */
session_start();
require 'db.php';

$msg = '';

// === 核心自愈逻辑：检测表是否存在，不存在则创建 ===
try {
    // 尝试做一次空查询，检测表是否存在
    $conn->query("SELECT 1 FROM admins LIMIT 1");
} catch (PDOException $e) {
    // 如果报错代码是 42S02 (Base table or view not found)
    if ($e->getCode() == '42S02') {
        // 自动创建表
        $sql = "CREATE TABLE IF NOT EXISTS admins (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) UNIQUE,
            password VARCHAR(255),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        $conn->exec($sql);
        
        // 自动插入默认管理员: admin / 123456
        $pass = password_hash('123456', PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT IGNORE INTO admins (username, password) VALUES (?, ?)");
        $stmt->execute(['admin', $pass]);
        
        $msg = "<div style='color:#00ffcc;margin-bottom:15px;font-size:12px;'>⚠️ 检测到系统升级，已自动修复管理员数据表。<br>默认账号: admin / 密码: 123456</div>";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = trim($_POST['username']);
    $p = trim($_POST['password']);
    
    $stmt = $conn->prepare("SELECT * FROM admins WHERE username = ?");
    $stmt->execute([$u]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($admin && password_verify($p, $admin['password'])) {
        $_SESSION['admin_logged_in'] = true;
        header("Location: admin.php");
        exit;
    } else {
        $msg = "<div style='color:#ff4444;margin-bottom:15px;'>账号或密码错误</div>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>系统登录 | 显眼包控制台</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { background: #000; color: #fff; font-family: -apple-system, sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; background-image: radial-gradient(#1a1a1a 1px, transparent 1px); background-size: 20px 20px; }
        .login-box { width: 320px; padding: 40px; background: rgba(20,20,20,0.9); border: 1px solid #333; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.5); text-align: center; backdrop-filter: blur(10px); }
        h2 { color: #fff; margin-bottom: 5px; letter-spacing: 1px; font-size: 24px; }
        p { color: #666; font-size: 12px; margin-bottom: 30px; text-transform: uppercase; letter-spacing: 2px; }
        input { width: 100%; padding: 14px; margin-bottom: 15px; background: #111; border: 1px solid #333; color: #fff; border-radius: 8px; box-sizing: border-box; outline: none; transition: 0.3s; font-size: 14px; }
        input:focus { border-color: #7000ff; background: #000; }
        button { width: 100%; padding: 14px; background: linear-gradient(90deg, #7000ff, #5a00d6); color: #fff; border: none; border-radius: 8px; font-weight: bold; cursor: pointer; transition: 0.3s; font-size: 14px; margin-top: 10px; }
        button:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(112,0,255,0.3); }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>SLICE ADMIN</h2>
        <p>System Control Panel</p>
        <?= $msg ?>
        <form method="post">
            <input type="text" name="username" placeholder="管理员账号" required>
            <input type="password" name="password" placeholder="访问密码" required>
            <button type="submit">立即登录</button>
        </form>
    </div>
</body>
</html>