<?php
// ai_core.php - 网络增强版
ini_set('display_errors', 0);
header('Content-Type: application/json');
require 'db.php';

// === 你的 Key ===
$API_KEY = 'sk-ptxelsfsgcruhfeutozooajthppikcbsqdgrytsflzetncpz';

// 尝试使用这个接口，如果还不行，可能你的服务器网络被墙了
$API_URL = 'https://api.siliconflow.cn/v1/chat/completions'; 

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $userMsg = $input['message'] ?? '';
    if (!$userMsg) throw new Exception('消息为空');

    $data = [
        "model" => "deepseek-ai/DeepSeek-V3",
        "messages" => [
            ["role" => "system", "content" => "你是显眼包社区的AI助手，说话要幽默简短，带点梗。"],
            ["role" => "user", "content" => $userMsg]
        ],
        "stream" => false,
        "max_tokens" => 512,
        "temperature" => 0.7
    ];

    $ch = curl_init($API_URL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $API_KEY",
        "Content-Type: application/json"
    ]);
    
    // === 关键修复网络设置 ===
    curl_setopt($ch, CURLOPT_TIMEOUT, 60); // 延长到60秒
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20); // 连接超时20秒
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 忽略 SSL 证书检查 (解决很多连接错误)
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr = curl_error($ch);
    curl_close($ch);

    if ($curlErr) {
        throw new Exception("服务器网络不通: " . $curlErr);
    }
    
    // 解析返回
    $json = json_decode($response, true);
    
    // 检查 API 是否返回了报错信息
    if (isset($json['error'])) {
        throw new Exception("API 拒绝: " . json_encode($json['error']));
    }

    $aiText = $json['choices'][0]['message']['content'] ?? '';
    if (!$aiText) throw new Exception("AI 没有回复内容 (HTTP $httpCode)");

    // AI 回复入库
    $stmt = $conn->prepare("INSERT INTO chat (username, avatar, message, is_ai) VALUES (?, ?, ?, 1)");
    $stmt->execute(['AI 显眼包', 'https://source.ictcode.com/images/W03.png', $aiText]);
    
    echo json_encode(['status' => 'success', 'reply' => $aiText]);

} catch (Exception $e) {
    // 记录错误到数据库以便在聊天框看到
    $errMsg = "AI 报错: " . $e->getMessage();
    $stmt = $conn->prepare("INSERT INTO chat (username, avatar, message, is_ai) VALUES (?, ?, ?, 1)");
    $stmt->execute(['系统警告', 'https://source.ictcode.com/images/W09.png', $errMsg]);
    
    echo json_encode(['status' => 'error', 'msg' => $errMsg]);
}
?>