<?php
/**
 * ai_helper.php - v3.0 稳定版
 * 负责调用硅基流动 API，包含防卡死超时控制
 */

function callSiliconFlow($messages, $model = 'Qwen/Qwen2.5-7B-Instruct') {
    $apiKey = get_setting('ai_api_key');
    if (empty($apiKey)) return null; 

    $url = "https://api.siliconflow.cn/v1/chat/completions";
    
    $data = [
        "model" => $model,
        "messages" => $messages,
        "stream" => false,
        "max_tokens" => 512, // 限制回复长度
        "temperature" => 0.7,
        "top_p" => 0.7,
        "frequency_penalty" => 0.5
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // 🔥 关键：设置超时，防止网页卡死
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3); // 连接超时 3秒
    curl_setopt($ch, CURLOPT_TIMEOUT, 6);        // 总执行超时 6秒
    
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) return null; // 如果超时直接放弃，不报错

    if ($response) {
        $json = json_decode($response, true);
        return $json['choices'][0]['message']['content'] ?? null;
    }
    return null;
}

// 触发 AI 评论帖子
function aiCommentPost($postId, $postContent) {
    global $conn;
    
    // 检查开关 (兼容字符串'1'和数字1)
    if (get_setting('ai_comment_open') != 1) return;
    
    $aiUserId = (int)get_setting('ai_user_id');
    if ($aiUserId <= 0) return; 

    // 获取AI人设
    $persona = get_setting('ai_persona', '你是一个幽默、热情、像真人一样的网友。请用简短、有趣的口语评价这段话，带一点emoji。');

    // 构造 Prompt
    $contentForAi = empty($postContent) ? "（用户分享了一张图片）" : $postContent;
    $messages = [
        ['role' => 'system', 'content' => $persona],
        ['role' => 'user', 'content' => "帖子内容：$contentForAi\n\n请给出一条简短的神评论："]
    ];

    try {
        $reply = callSiliconFlow($messages);
        
        if ($reply) {
            $aiUser = $conn->query("SELECT username, avatar FROM users WHERE id=$aiUserId")->fetch(PDO::FETCH_ASSOC);
            if ($aiUser) {
                // 写入评论
                $stmt = $conn->prepare("INSERT INTO comments (post_id, user_id, username, content, created_at) VALUES (?, ?, ?, ?, NOW())");
                $stmt->execute([$postId, $aiUserId, $aiUser['username'], $reply]);
                
                // 给帖主发通知
                $owner = $conn->query("SELECT user_id FROM posts WHERE id=$postId")->fetchColumn();
                if ($owner && $owner != $aiUserId) {
                    $conn->prepare("INSERT INTO notifications (receiver_id, sender_id, type, post_id, content) VALUES (?, ?, 'comment', ?, ?)")
                         ->execute([$owner, $aiUserId, $postId, mb_substr($reply,0,20)]);
                }
            }
        }
    } catch (Exception $e) {}
}

// 触发 AI 私聊回复
function aiReplyChat($fromUserId, $msgContent) {
    global $conn;
    
    if (get_setting('ai_chat_open') != 1) return;
    
    $aiUserId = (int)get_setting('ai_user_id');
    if ($fromUserId == $aiUserId) return; // 不回复自己

    $persona = get_setting('ai_persona', '你是一个知心朋友，名字叫小S。');

    $messages = [
        ['role' => 'system', 'content' => $persona],
        ['role' => 'user', 'content' => $msgContent]
    ];

    try {
        $reply = callSiliconFlow($messages);
        
        if ($reply) {
            $aiUser = $conn->query("SELECT username, avatar FROM users WHERE id=$aiUserId")->fetch(PDO::FETCH_ASSOC);
            if ($aiUser) {
                // 写入回复
                $stmt = $conn->prepare("INSERT INTO chat (from_user_id, to_user_id, username, avatar, message, created_at, is_read) VALUES (?, ?, ?, ?, ?, NOW(), 0)");
                $stmt->execute([$aiUserId, $fromUserId, $aiUser['username'], $aiUser['avatar'], $reply]);
            }
        }
    } catch (Exception $e) {}
}
?>