<?php
/**
 * api.php - v23.0 核心交互接口
 * 包含：关注/取关(含互关判断)、修改资料、上传头像
 */
require 'db.php';
header('Content-Type: application/json');

$action = $_REQUEST['action'] ?? '';
$token = $_COOKIE['xyb_token'] ?? '';
$currentUser = null;

if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $currentUser = $stmt->fetch(PDO::FETCH_ASSOC);
}

if (!$currentUser) {
    echo json_encode(['status'=>'error', 'msg'=>'请先登录']);
    exit;
}

try {
    // --- 1. 关注 / 取消关注 ---
    if ($action === 'follow') {
        $targetId = intval($_POST['id']);
        if ($targetId <= 0 || $targetId == $currentUser['id']) {
            echo json_encode(['status'=>'error', 'msg'=>'操作无效']); exit;
        }

        // 检查是否已关注
        $check = $conn->prepare("SELECT id FROM follows WHERE follower_id = ? AND following_id = ?");
        $check->execute([$currentUser['id'], $targetId]);
        $row = $check->fetch();

        if ($row) {
            // 取消关注
            $conn->prepare("DELETE FROM follows WHERE id = ?")->execute([$row['id']]);
            echo json_encode(['status'=>'success', 'type'=>'unfollowed', 'label'=>'关注']);
        } else {
            // 添加关注
            $conn->prepare("INSERT INTO follows (follower_id, following_id) VALUES (?, ?)")->execute([$currentUser['id'], $targetId]);
            
            // 发送通知
            $conn->prepare("INSERT INTO notifications (receiver_id, sender_id, type, content) VALUES (?, ?, 'follow', '关注了你')")
                 ->execute([$targetId, $currentUser['id']]);

            // 🔥 检查是否互相关注 (对方是否也关注了我)
            $checkMutual = $conn->prepare("SELECT id FROM follows WHERE follower_id = ? AND following_id = ?");
            $checkMutual->execute([$targetId, $currentUser['id']]); // 反向查
            $isMutual = $checkMutual->fetch();

            $labelText = $isMutual ? '互相关注' : '已关注';
            echo json_encode(['status'=>'success', 'type'=>'followed', 'label'=>$labelText, 'is_mutual'=>$isMutual ? 1 : 0]);
        }
    }

    // --- 2. 修改资料 (昵称/简介) ---
    elseif ($action === 'update_profile') {
        $name = trim($_POST['name']);
        $bio = trim($_POST['bio']);
        if (!$name) throw new Exception('昵称不能为空');
        
        // 查重 (排除自己)
        $check = $conn->prepare("SELECT id FROM users WHERE username = ? AND id != ?");
        $check->execute([$name, $currentUser['id']]);
        if ($check->fetch()) throw new Exception('昵称已被占用');

        $stmt = $conn->prepare("UPDATE users SET username = ?, bio = ? WHERE id = ?");
        $stmt->execute([$name, $bio, $currentUser['id']]);
        echo json_encode(['status'=>'success', 'msg'=>'资料已更新']);
    }

    // --- 3. 上传头像 ---
    elseif ($action === 'upload_avatar') {
        if (empty($_FILES['avatar']['name'])) throw new Exception('请选择图片');
        
        $dir = 'uploads/avatar/';
        if (!is_dir($dir)) mkdir($dir, 0777, true);
        
        $ext = pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION);
        $filename = 'a' . $currentUser['id'] . '_' . time() . '.' . $ext;
        $path = $dir . $filename;
        
        if (move_uploaded_file($_FILES['avatar']['tmp_name'], $path)) {
            $conn->prepare("UPDATE users SET avatar = ? WHERE id = ?")->execute([$path, $currentUser['id']]);
            echo json_encode(['status'=>'success', 'url'=>$path]);
        } else {
            throw new Exception('上传失败');
        }
    }

    // --- 4. 获取联系人 (聊天页用 - 兼容旧逻辑) ---
    elseif ($action === 'get_contacts') {
        // 这里的逻辑主要在 chat.php 的 poll 接口中，但为了兼容部分旧逻辑保留
        echo json_encode(['status'=>'success', 'data'=>[]]);
    }

    else {
        echo json_encode(['status'=>'error', 'msg'=>'未知操作']);
    }

} catch (Exception $e) {
    echo json_encode(['status'=>'error', 'msg'=>$e->getMessage()]);
}
?>