<?php
/**
 * api_user.php - v26.0 包含背景上传
 */
require 'db.php';
header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$token = $_COOKIE['xyb_token'] ?? '';
$user = null;

if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

if (!$user) { echo json_encode(['status'=>'error','msg'=>'请先登录']); exit; }
$uid = $user['id'];

try {
    // 1. 购买
    if ($action === 'buy') {
        $aid = intval($_POST['id']);
        $asset = $conn->query("SELECT * FROM assets WHERE id=$aid")->fetch(PDO::FETCH_ASSOC);
        if (!$asset) throw new Exception('商品不存在');
        if ($user['points'] < $asset['price']) throw new Exception('积分不足');
        
        $conn->prepare("UPDATE users SET points = points - ? WHERE id = ?")->execute([$asset['price'], $uid]);
        $conn->prepare("INSERT INTO user_assets (user_id, asset_id) VALUES (?, ?)")->execute([$uid, $aid]);
        echo json_encode(['status'=>'success', 'msg'=>'兑换成功']);
    }

    // 2. 装备/卸下
    elseif ($action === 'equip') {
        $uaId = intval($_POST['ua_id']);
        $item = $conn->query("SELECT ua.*, a.type FROM user_assets ua LEFT JOIN assets a ON ua.asset_id=a.id WHERE ua.id=$uaId AND ua.user_id=$uid")->fetch(PDO::FETCH_ASSOC);
        if (!$item) throw new Exception('物品不存在');
        
        if ($item['is_equipped'] == 1) {
            $conn->query("UPDATE user_assets SET is_equipped=0 WHERE id=$uaId");
            echo json_encode(['status'=>'success', 'msg'=>'已卸下']);
        } else {
            $conn->query("UPDATE user_assets ua JOIN assets a ON ua.asset_id=a.id SET ua.is_equipped=0 WHERE ua.user_id=$uid AND a.type='{$item['type']}'");
            $conn->query("UPDATE user_assets SET is_equipped=1 WHERE id=$uaId");
            // 如果装备的是背景，清空 DIY 背景，优先使用装备
            if ($item['type'] == 'bg') {
                // 这里我们不做强制清空 background 字段，而是前端逻辑优先判断 background 字段
                // 如果用户想用商城背景，最好在上传接口里把 background 字段置空，或者提供一个“移除DIY”的按钮
                // 为了简单，我们这里清空 background 字段，确保商城背景生效
                $conn->prepare("UPDATE users SET background='' WHERE id=?")->execute([$uid]);
            }
            echo json_encode(['status'=>'success', 'msg'=>'装备成功']);
        }
    }

    // 3. 🔥 上传自定义背景
    elseif ($action === 'upload_bg') {
        if (empty($_FILES['image']['name'])) throw new Exception('请选择图片');
        
        $dir = 'uploads/bg/';
        if (!is_dir($dir)) mkdir($dir, 0777, true);
        
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        if (!in_array($ext, ['jpg','jpeg','png','webp','gif'])) throw new Exception('格式不支持');
        
        $filename = 'bg_' . $uid . '_' . time() . '.' . $ext;
        $path = $dir . $filename;
        
        if (move_uploaded_file($_FILES['image']['tmp_name'], $path)) {
            // 更新数据库
            $conn->prepare("UPDATE users SET background = ? WHERE id = ?")->execute([$path, $uid]);
            // 同时卸下所有商城背景，避免逻辑冲突
            $conn->query("UPDATE user_assets ua JOIN assets a ON ua.asset_id=a.id SET ua.is_equipped=0 WHERE ua.user_id=$uid AND a.type='bg'");
            
            echo json_encode(['status'=>'success', 'url'=>$path]);
        } else {
            throw new Exception('上传失败');
        }
    }
    
    else { echo json_encode(['status'=>'error', 'msg'=>'未知操作']); }

} catch (Exception $e) {
    echo json_encode(['status'=>'error', 'msg'=>$e->getMessage()]);
}
?>