<?php
/**
 * auth.php - 登录/注册 (集成 IP 属地更新)
 */
require 'db.php';
require 'ip_helper.php'; // 🔥 引入新建的 IP 工具

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';
$username = trim($_POST['username'] ?? '');
$password = trim($_POST['password'] ?? '');

if (!$username || !$password) {
    echo json_encode(['status'=>'error', 'msg'=>'请输入账号和密码']); exit;
}

try {
    // 🔥 获取 IP 和 城市
    $ip = get_real_ip();
    $city = get_city_by_ip($ip);

    // --- 注册逻辑 ---
    if ($action === 'register') {
        // 查重
        $check = $conn->prepare("SELECT id FROM users WHERE username = ?");
        $check->execute([$username]);
        if ($check->fetch()) {
            echo json_encode(['status'=>'error', 'msg'=>'该昵称已被占用']); exit;
        }

        $token = bin2hex(random_bytes(16));
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $avatar = "https://ui-avatars.com/api/?name=".urlencode($username)."&background=random&color=fff";
        
        // 插入用户 (带 city 和 points)
        $stmt = $conn->prepare("INSERT INTO users (username, password, token, avatar, city, role, points) VALUES (?, ?, ?, ?, ?, 'user', 100)");
        
        if ($stmt->execute([$username, $hash, $token, $avatar, $city])) {
            setcookie('xyb_token', $token, time() + 86400 * 30, "/");
            echo json_encode(['status'=>'success', 'msg'=>"欢迎加入，IP属地：$city"]);
        } else {
            echo json_encode(['status'=>'error', 'msg'=>'注册失败']);
        }
    }

    // --- 登录逻辑 ---
    elseif ($action === 'login') {
        $stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            echo json_encode(['status'=>'error', 'msg'=>'账号不存在']); exit;
        }

        if (empty($user['password'])) {
            echo json_encode(['status'=>'error', 'msg'=>'旧版账号无法登录，请注册新号']); exit;
        }

        if (password_verify($password, $user['password'])) {
            $newToken = bin2hex(random_bytes(16));
            
            // 🔥 登录时更新 Token 和 City
            $conn->prepare("UPDATE users SET token = ?, city = ? WHERE id = ?")->execute([$newToken, $city, $user['id']]);
            
            setcookie('xyb_token', $newToken, time() + 86400 * 30, "/");
            echo json_encode(['status'=>'success', 'msg'=>"欢迎回来，IP已更新：$city"]);
        } else {
            echo json_encode(['status'=>'error', 'msg'=>'密码错误']);
        }
    }

} catch (Exception $e) {
    echo json_encode(['status'=>'error', 'msg'=>'系统错误: '.$e->getMessage()]);
}
?>