<?php
/**
 * chat.php - v29.0 AI私聊集成版
 * 1. 扩充了 Emoji 库
 * 2. 🔥 集成 AI 回复功能
 */
require 'db.php';

// 🔥 引入 AI 引擎
if (file_exists('ai_helper.php')) require_once 'ai_helper.php';

$token = $_COOKIE['xyb_token'] ?? '';
$currentUser = null;
if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $currentUser = $stmt->fetch(PDO::FETCH_ASSOC);
}
if (!$currentUser) { header("Location: login.php"); exit; }

$myId = $currentUser['id'];
$toId = intval($_GET['to_id'] ?? 0); // 0=公共频道

// --- 1. 发送消息接口 ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'send') {
    $msg = trim($_POST['msg']);
    if ($msg === '') { echo json_encode(['status'=>'error', 'msg'=>'不能发送空消息']); exit; }

    if ($toId > 0) {
        // 防骚扰逻辑
        $isMutual = $conn->query("SELECT count(*) FROM follows f1 
                                  JOIN follows f2 ON f1.following_id = f2.follower_id 
                                  WHERE f1.follower_id = $myId AND f1.following_id = $toId 
                                  AND f2.follower_id = $toId AND f2.following_id = $myId")->fetchColumn();

        if (!$isMutual) {
            $sentCount = $conn->query("SELECT count(*) FROM chat WHERE from_user_id=$myId AND to_user_id=$toId")->fetchColumn();
            $replyCount = $conn->query("SELECT count(*) FROM chat WHERE from_user_id=$toId AND to_user_id=$myId")->fetchColumn();
            
            // 🔥 如果是发给 AI 机器人，跳过“非互关限制”
            $aiUserId = (int)get_setting('ai_user_id');
            if ($toId != $aiUserId) {
                if ($sentCount >= 1 && $replyCount == 0) {
                    echo json_encode(['status'=>'error', 'msg'=>'非互关好友，对方回复前仅限发送1条消息']);
                    exit;
                }
            }
        }
    }

    // 写入消息
    $stmt = $conn->prepare("INSERT INTO chat (from_user_id, to_user_id, message, username, avatar, is_read, created_at) VALUES (?, ?, ?, ?, ?, 0, NOW())");
    $stmt->execute([$myId, $toId, $msg, $currentUser['username'], $currentUser['avatar']]);
    
    // 🔥🔥🔥 核心：如果对方是机器人，立即触发 AI 回复 🔥🔥🔥
    $aiUserId = (int)get_setting('ai_user_id');
    if ($toId == $aiUserId && function_exists('aiReplyChat')) {
        aiReplyChat($myId, $msg);
    }

    echo json_encode(['status'=>'success']);
    exit;
}

// --- 2. 轮询接口 ---
if (isset($_GET['action']) && $_GET['action'] === 'poll') {
    header('Content-Type: application/json');
    
    // 消息
    $messages = [];
    if ($toId == 0) {
        $messages = $conn->query("SELECT * FROM (SELECT * FROM chat WHERE to_user_id = 0 ORDER BY id DESC LIMIT 50) sub ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
    } else {
        $messages = $conn->query("SELECT * FROM chat WHERE (from_user_id=$myId AND to_user_id=$toId) OR (from_user_id=$toId AND to_user_id=$myId) ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
        $conn->exec("UPDATE chat SET is_read = 1 WHERE from_user_id = $toId AND to_user_id = $myId AND is_read = 0");
    }

    // 联系人
    $contacts = [];
    $sql = "SELECT CASE WHEN from_user_id = $myId THEN to_user_id ELSE from_user_id END as uid, MAX(created_at) as last_time
            FROM chat WHERE (from_user_id = $myId OR to_user_id = $myId) AND to_user_id != 0 
            GROUP BY uid ORDER BY last_time DESC";
    $contact_ids = $conn->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    
    foreach($contact_ids as $c) {
        $uid = $c['uid'];
        $u = $conn->query("SELECT id, username, avatar FROM users WHERE id = $uid")->fetch(PDO::FETCH_ASSOC);
        if($u) {
            $u['unread'] = $conn->query("SELECT count(*) FROM chat WHERE from_user_id=$uid AND to_user_id=$myId AND is_read=0")->fetchColumn();
            $contacts[] = $u;
        }
    }

    echo json_encode(['status'=>'success', 'msgs'=>$messages, 'contacts'=>$contacts, 'my_id'=>$myId]);
    exit;
}

$chatTitle = '公共聊天室';
if ($toId > 0) {
    $u = $conn->query("SELECT username FROM users WHERE id = $toId")->fetchColumn();
    if ($u) $chatTitle = $u;
}
$siteName = get_setting('site_name', 'Slice');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title><?= htmlspecialchars($chatTitle) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --p: #ff2442; --bg: #fff; --gray-bg: #f2f4f6; --border: #eee; --me-bg: #ff2442; --other-bg: #fff; }
        * { box-sizing: border-box; margin:0; padding:0; -webkit-tap-highlight-color:transparent; }
        body { background: var(--bg); font-family: -apple-system, sans-serif; height: 100vh; display: flex; overflow: hidden; color: #333; }

        /* 左侧边栏 */
        .sidebar { width: 280px; background: #fff; border-right: 1px solid var(--border); display: flex; flex-direction: column; z-index: 20; }
        .sb-header { height: 60px; display: flex; align-items: center; padding: 0 20px; font-weight: 900; font-size: 18px; border-bottom: 1px solid var(--border); justify-content: space-between; }
        .home-icon { font-size: 18px; color: #333; cursor: pointer; transition: 0.2s; }
        .home-icon:hover { color: var(--p); }

        .contact-list { flex: 1; overflow-y: auto; }
        .contact-item { display: flex; align-items: center; padding: 12px 20px; cursor: pointer; transition: 0.2s; position: relative; }
        .contact-item:hover, .contact-item.active { background: var(--gray-bg); }
        .c-avatar { width: 44px; height: 44px; border-radius: 50%; margin-right: 12px; object-fit: cover; border: 1px solid #eee; }
        .c-info { flex: 1; overflow: hidden; }
        .c-name { font-weight: bold; font-size: 15px; margin-bottom: 2px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .c-desc { font-size: 12px; color: #999; }
        .unread-dot { position: absolute; right: 15px; top: 50%; transform: translateY(-50%); background: var(--p); color: #fff; font-size: 10px; padding: 2px 6px; border-radius: 10px; font-weight: bold; }

        /* 右侧聊天主区 */
        .chat-area { flex: 1; display: flex; flex-direction: column; background: var(--gray-bg); position: relative; }
        .chat-header { height: 60px; background: #fff; border-bottom: 1px solid var(--border); display: flex; align-items: center; padding: 0 20px; justify-content: space-between; font-weight: bold; font-size: 16px; flex-shrink: 0; }
        .back-btn { display: none; font-size: 20px; cursor: pointer; margin-right: 15px; }

        .msg-list { flex: 1; overflow-y: auto; padding: 20px; display: flex; flex-direction: column; gap: 20px; scroll-behavior: smooth; padding-bottom: 20px; }
        .msg-list::-webkit-scrollbar { width: 6px; }
        .msg-list::-webkit-scrollbar-thumb { background: #ddd; border-radius: 3px; }

        .msg { display: flex; gap: 10px; max-width: 75%; }
        .msg.me { align-self: flex-end; flex-direction: row-reverse; }
        .m-avatar { width: 36px; height: 36px; border-radius: 50%; cursor: pointer; flex-shrink: 0; }
        
        .m-content { display: flex; flex-direction: column; align-items: flex-start; }
        .msg.me .m-content { align-items: flex-end; }
        
        .bubble { padding: 10px 14px; border-radius: 12px; font-size: 15px; line-height: 1.5; background: var(--other-bg); color: #333; box-shadow: 0 1px 2px rgba(0,0,0,0.05); position: relative; word-break: break-all; }
        .msg.me .bubble { background: var(--me-bg); color: #fff; }
        
        .status { font-size: 10px; color: #999; margin-top: 4px; transform: scale(0.9); transform-origin: right top; }
        .status.unread { color: var(--p); font-weight: bold; }

        /* 输入区 */
        .input-area { background: #fff; padding: 10px 15px; border-top: 1px solid var(--border); display: flex; gap: 10px; align-items: center; position: relative; padding-bottom: calc(10px + env(safe-area-inset-bottom)); }
        .icon-btn { font-size: 24px; color: #666; cursor: pointer; transition: 0.2s; }
        .icon-btn:hover, .icon-btn.active { color: var(--p); }
        .ipt { flex: 1; background: var(--gray-bg); border: none; height: 40px; border-radius: 20px; padding: 0 15px; font-size: 15px; outline: none; }
        .send-btn { width: 40px; height: 40px; background: var(--p); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #fff; cursor: pointer; flex-shrink: 0; transition: 0.2s; }
        .send-btn:active { transform: scale(0.95); }

        /* 表情面板 */
        .emoji-panel { 
            display: none; height: 200px; overflow-y: auto; background: #fff; border-top: 1px solid #eee;
            padding: 15px; grid-template-columns: repeat(8, 1fr); gap: 10px;
        }
        .emoji-panel.show { display: grid; }
        .emoji-item { font-size: 24px; text-align: center; cursor: pointer; transition: 0.1s; user-select: none; }
        .emoji-item:active { transform: scale(1.2); }

        @media (max-width: 768px) {
            .sidebar { width: 100%; position: absolute; top: 0; left: 0; height: 100%; }
            .chat-area { width: 100%; position: absolute; top: 0; left: 100%; height: 100%; transition: transform 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94); z-index: 30; }
            .chat-area.active { transform: translateX(-100%); }
            .back-btn { display: block; }
            .msg { max-width: 85%; }
            .emoji-panel { height: 240px; grid-template-columns: repeat(7, 1fr); }
        }
    </style>
</head>
<body>

<div class="sidebar">
    <div class="sb-header">
        <span>消息</span>
        <i class="fa-solid fa-house home-icon" onclick="location.href='index.php'" title="回首页"></i>
    </div>
    <div class="contact-list" id="contactList">
        <div class="contact-item <?= $toId==0?'active':'' ?>" onclick="switchChat(0, '公共聊天室')">
            <div style="width:44px;height:44px;border-radius:50%;background:#333;display:flex;align-items:center;justify-content:center;color:#fff;margin-right:12px;font-size:20px;"><i class="fa-solid fa-earth-asia"></i></div>
            <div class="c-info"><div class="c-name">公共聊天室</div><div class="c-desc">和大家一起畅聊</div></div>
        </div>
        <div style="height:1px;background:#f5f5f5;margin:5px 20px;"></div>
    </div>
</div>

<div class="chat-area <?= $toId!==null?'active':'' ?>" id="chatArea">
    <div class="chat-header">
        <div style="display:flex;align-items:center;">
            <i class="fa-solid fa-chevron-left back-btn" onclick="closeChat()"></i>
            <span id="headerTitle"><?= htmlspecialchars($chatTitle) ?></span>
        </div>
        <i id="userProfileBtn" class="fa-solid fa-user" style="color:#999;cursor:pointer;<?= $toId==0?'display:none':'' ?>" onclick="location.href='user.php?id='+currentToId"></i>
    </div>

    <div class="msg-list" id="msgBox">
        <div style="text-align:center;color:#999;margin-top:20px;">加载中...</div>
    </div>

    <div class="input-area">
        <i class="fa-regular fa-face-smile icon-btn" id="emojiBtn" onclick="toggleEmoji()"></i>
        <input type="text" class="ipt" id="msgInput" placeholder="说点什么..." autocomplete="off">
        <div class="send-btn" onclick="sendMsg()"><i class="fa-solid fa-paper-plane"></i></div>
    </div>
    <div class="emoji-panel" id="emojiPanel"></div>
</div>

<script>
    let currentToId = <?= $toId ?>;
    let myId = <?= $myId ?>;
    let isMobile = window.innerWidth <= 768;
    const emojiPanel = document.getElementById('emojiPanel');
    const msgInput = document.getElementById('msgInput');

    // 🔥 100+ 常用表情库
    const emojis = [
        '😀','😃','😄','😁','😆','😅','😂','🤣','🥲','☺️','😊','😇','🙂','🙃','😉','😌','😍','🥰','😘','😗','😙','😚','😋','😛','😝','😜','🤪','🤨','🧐','🤓','😎','🥸','🤩','🥳','😏','😒','😞','😔','😟','😕','🙁','☹️','😣','😖','😫','😩','🥺','😢','😭','😤','😠','😡','🤬','🤯','😳','🥵','🥶','😱','😨','😰','😥','😓','🤗','🤔','🤭','🤫','🤥','😶','😐','😑','😬','🙄','😯','😦','😧','😮','😲','🥱','😴','🤤','😪','😵','🤐','🥴','🤢','🤮','🤧','😷','🤒','🤕','🤑','🤠','😈','👿','👹','👺','🤡','💩','👻','💀','☠️','👽','👾','🤖','🎃','😺','😹','😻','😼','😽','🙀','😿','😾','👋','🤚','🖐','✋','🖖','👌','🤏','✌️','🤞','🤟','🤘','🤙','👈','👉','👆','🖕','👇','☝️','👍','👎','✊','👊','🤛','🤜','👏','🙌','👐','🤲','🤝','🙏','✍️','💅','🤳','💪','🦵','🦶','👂','🦻','👃','🧠','🫀','🫁','🦷','🦴','👀','👁','👅','👄','💋','🩸'
    ];

    // 初始化表情面板
    emojis.forEach(e => {
        let span = document.createElement('span');
        span.className = 'emoji-item';
        span.innerText = e;
        span.onclick = () => {
            msgInput.value += e;
            msgInput.focus();
        };
        emojiPanel.appendChild(span);
    });

    function toggleEmoji() {
        emojiPanel.classList.toggle('show');
        document.getElementById('emojiBtn').classList.toggle('active');
        // 自动滚动到底部
        if(emojiPanel.classList.contains('show')) {
            setTimeout(() => {
                const box = document.getElementById('msgBox');
                box.scrollTop = box.scrollHeight;
            }, 100);
        }
    }

    function init() {
        if(isMobile && window.location.search.indexOf('to_id') === -1) {
            document.getElementById('chatArea').classList.remove('active');
        } else if (isMobile) {
            document.getElementById('chatArea').classList.add('active');
        }
        pollData();
        setInterval(pollData, 3000);
    }

    window.switchChat = function(id, name) {
        currentToId = id;
        document.getElementById('headerTitle').innerText = name;
        document.getElementById('userProfileBtn').style.display = id==0 ? 'none' : 'block';
        document.getElementById('msgBox').innerHTML = '<div style="text-align:center;color:#999;margin-top:20px;">加载中...</div>';
        
        emojiPanel.classList.remove('show'); // 切换时关闭表情
        
        if (isMobile) document.getElementById('chatArea').classList.add('active');
        
        const url = new URL(window.location);
        url.searchParams.set('to_id', id);
        window.history.pushState({}, '', url);
        pollData();
    }

    window.closeChat = function() {
        document.getElementById('chatArea').classList.remove('active');
        const url = new URL(window.location);
        url.searchParams.delete('to_id');
        window.history.pushState({}, '', url);
    }

    window.sendMsg = function() {
        const txt = msgInput.value.trim();
        if(!txt) return;

        const fd = new FormData();
        fd.append('action', 'send');
        fd.append('msg', txt);
        msgInput.value = '';
        emojiPanel.classList.remove('show'); // 发送后关闭表情

        fetch(`chat.php?to_id=${currentToId}`, { method: 'POST', body: fd })
            .then(r => r.json())
            .then(res => {
                if(res.status === 'success') {
                    pollData();
                } else {
                    alert(res.msg || '发送失败');
                }
            });
    }

    msgInput.addEventListener('keypress', (e) => {
        if(e.key === 'Enter') sendMsg();
    });
    
    // 点击输入框时隐藏表情面板
    msgInput.addEventListener('focus', () => {
        emojiPanel.classList.remove('show');
        document.getElementById('emojiBtn').classList.remove('active');
    });

    function pollData() {
        fetch(`chat.php?action=poll&to_id=${currentToId}`)
            .then(r => r.json())
            .then(res => {
                if(res.status !== 'success') return;
                myId = res.my_id;

                // 渲染列表
                const list = document.getElementById('contactList');
                const publicItem = list.firstElementChild; 
                let contactsHtml = '';
                res.contacts.forEach(c => {
                    const active = c.id == currentToId ? 'active' : '';
                    const unreadHtml = c.unread > 0 ? `<div class="unread-dot">${c.unread}</div>` : '';
                    contactsHtml += `
                        <div class="contact-item ${active}" onclick="switchChat(${c.id}, '${c.username}')">
                            <img src="${c.avatar}" class="c-avatar">
                            <div class="c-info"><div class="c-name">${c.username}</div><div class="c-desc">点击聊天</div></div>
                            ${unreadHtml}
                        </div>`;
                });
                while(list.children.length > 2) { list.removeChild(list.lastChild); }
                list.insertAdjacentHTML('beforeend', contactsHtml);
                
                if(currentToId == 0) publicItem.classList.add('active');
                else publicItem.classList.remove('active');

                // 渲染消息
                const box = document.getElementById('msgBox');
                const isBottom = box.scrollHeight - box.scrollTop <= box.clientHeight + 150;
                
                let msgHtml = '';
                if(res.msgs.length === 0) {
                    msgHtml = '<div style="text-align:center;color:#ccc;margin-top:50px;">暂无消息，开始聊天吧</div>';
                } else {
                    res.msgs.forEach(m => {
                        const isMe = m.from_user_id == myId;
                        let statusHtml = '';
                        if (isMe && currentToId > 0) { 
                            const sText = m.is_read == 1 ? '已读' : '未读';
                            const sClass = m.is_read == 1 ? '' : 'unread';
                            statusHtml = `<div class="status ${sClass}">${sText}</div>`;
                        }
                        msgHtml += `
                            <div class="msg ${isMe?'me':''}">
                                <img src="${m.avatar}" class="m-avatar" onclick="location.href='user.php?id=${m.from_user_id}'">
                                <div class="m-content">
                                    <div class="bubble">${escapeHtml(m.message)}</div>
                                    ${statusHtml}
                                </div>
                            </div>`;
                    });
                }
                if (box.innerHTML.length !== msgHtml.length) {
                    box.innerHTML = msgHtml;
                    if(isBottom) box.scrollTop = box.scrollHeight;
                }
            });
    }

    function escapeHtml(text) {
        return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
    }

    init();
</script>
</body>
</html>