<?php
/**
 * fix_city.php - 强制刷新当前用户 IP 属地 (无需重登)
 */
require 'db.php';
require 'ip_helper.php'; // 🔥 引入 IP 工具

header('Content-Type: text/html; charset=utf-8');

$token = $_COOKIE['xyb_token'] ?? '';
if (!$token) die("请先登录账号，然后再访问此页面。");

// 1. 获取当前用户
$stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
$stmt->execute([$token]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) die("登录失效，请重新登录。");

echo "<body style='font-family:sans-serif; padding:20px; line-height:1.8;'>";
echo "<h2>🌍 正在刷新您的 IP 属地...</h2>";

// 2. 获取 IP 和 城市
$ip = get_real_ip();
echo "您的 IP 地址: <b>$ip</b><br>";

$city = get_city_by_ip($ip);
echo "解析出的城市: <b>$city</b><br>";

// 3. 更新数据库
try {
    $conn->prepare("UPDATE users SET city = ? WHERE id = ?")->execute([$city, $user['id']]);
    echo "<hr><h3 style='color:green'>✅ 更新成功！</h3>";
    echo "现在您的个人主页和所有帖子都会显示：<b>$city</b><br><br>";
    echo "<a href='user.php' style='background:#ff2442;color:#fff;text-decoration:none;padding:8px 20px;border-radius:20px;'>返回个人中心</a>";
} catch (Exception $e) {
    echo "<h3 style='color:red'>更新失败: ".$e->getMessage()."</h3>";
}
echo "</body>";
?>