<?php
/**
 * index.php - v30.0 完整修复版
 * 1. 修复 PHP 8.x stripslashes(null) 报错
 * 2. 包含完整的侧边栏、移动端适配、发布功能
 * 3. 支持显示用户称号 (Title)
 */
require 'db.php';

// --- 1. 身份验证逻辑 ---
$token = $_COOKIE['xyb_token'] ?? '';
$currentUser = null;

if ($token) {
    try {
        $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
        $stmt->execute([$token]);
        $currentUser = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch(Exception $e) {}
}

// --- 2. 数据查询逻辑 ---
$siteName = get_setting('site_name', 'Slice社区');
$tab = $_GET['tab'] ?? 'discover'; 
$q = isset($_GET['q']) ? trim($_GET['q']) : '';

// 游客访问限制
if (!$currentUser && ($tab === 'follow' || $tab === 'same_city')) {
    $tab = 'discover';
}

// 获取热搜
try { 
    $trending = $conn->query("SELECT content FROM posts ORDER BY likes DESC LIMIT 10")->fetchAll(PDO::FETCH_COLUMN); 
} catch(Exception $e) { $trending = []; }

// 🔥 核心查询：包含称号子查询
$sql = "SELECT p.*, u.username, u.avatar, u.city,
        (SELECT value FROM user_assets ua LEFT JOIN assets a ON ua.asset_id=a.id WHERE ua.user_id=u.id AND ua.is_equipped=1 AND a.type='title' LIMIT 1) as title_text,
        (SELECT style FROM user_assets ua LEFT JOIN assets a ON ua.asset_id=a.id WHERE ua.user_id=u.id AND ua.is_equipped=1 AND a.type='title' LIMIT 1) as title_style
        FROM posts p 
        LEFT JOIN users u ON p.user_id = u.id";

$params = [];

if ($q) {
    $sql .= " WHERE p.content LIKE ? OR u.city LIKE ?";
    $params = ["%$q%", "%$q%"];
} elseif ($tab === 'same_city') {
    $myCity = $currentUser['city'] ?: '未知';
    $sql .= " WHERE u.city = ?"; 
    $params = [$myCity];
} elseif ($tab === 'follow') {
    $sql .= " JOIN follows f ON f.following_id = p.user_id WHERE f.follower_id = ?";
    $params = [$currentUser['id']];
}

if ($tab === 'rank') {
    $sql .= " ORDER BY p.likes DESC LIMIT 50";
} else {
    $sql .= " ORDER BY p.id DESC LIMIT 50";
}

try {
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(Exception $e) { $posts = []; }

// 未读消息
$unread_total = 0;
if ($currentUser) {
    $myId = $currentUser['id'];
    try {
        $unread_total = (int)$conn->query("SELECT (SELECT COUNT(*) FROM notifications WHERE receiver_id=$myId AND is_read=0) + (SELECT COUNT(*) FROM chat WHERE to_user_id=$myId AND is_read=0)")->fetchColumn();
    } catch(Exception $e) {}
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?= htmlspecialchars($siteName) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --bg: #f8f8f8; --white: #fff; --text: #333; --p: #ff2442; --sidebar-w: 240px; }
        * { margin: 0; padding: 0; box-sizing: border-box; outline: none; -webkit-tap-highlight-color: transparent; }
        body { background: var(--bg); font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; color: var(--text); padding-bottom: 70px; }
        a { text-decoration: none; color: inherit; }

        .app-container { display: flex; max-width: 1400px; margin: 0 auto; min-height: 100vh; }
        .sidebar { width: var(--sidebar-w); position: sticky; top: 0; height: 100vh; padding: 30px 20px; display: flex; flex-direction: column; border-right: 1px solid rgba(0,0,0,0.05); background: var(--bg); z-index: 90; flex-shrink: 0; }
        .logo { font-size: 26px; font-weight: 900; color: var(--p); margin-bottom: 40px; display: flex; align-items: center; gap: 10px; padding-left: 10px; letter-spacing: -1px; }
        .nav-menu { display: flex; flex-direction: column; gap: 8px; flex: 1; }
        .nav-item { display: flex; align-items: center; gap: 15px; padding: 12px 15px; border-radius: 12px; font-size: 16px; color: #555; font-weight: 600; transition: 0.2s; position: relative; }
        .nav-item:hover { background: rgba(0,0,0,0.04); color: #000; }
        .nav-item.active { font-weight: 900; color: #333; background: #fff; box-shadow: 0 2px 8px rgba(0,0,0,0.03); }
        .nav-item svg { width: 22px; height: 22px; fill: currentColor; }
        .pc-badge { background: var(--p); color: #fff; font-size: 11px; padding: 1px 6px; border-radius: 10px; position: absolute; right: 15px; font-weight: bold; }
        .btn-create { margin-top: 20px; background: var(--p); color: #fff; border: none; padding: 14px; border-radius: 30px; font-size: 16px; font-weight: bold; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 8px; transition: 0.2s; box-shadow: 0 4px 15px rgba(255, 36, 66, 0.2); }
        .btn-create:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(255, 36, 66, 0.3); }

        .main-content { flex: 1; padding: 20px 40px; min-width: 0; }
        .top-bar-pc { display: flex; align-items: center; gap: 30px; margin-bottom: 20px; border-bottom: 1px solid #eee; padding-bottom: 10px; position: sticky; top: 0; background: var(--bg); z-index: 80; }
        .pc-tab { font-size: 16px; color: #999; cursor: pointer; padding: 5px 0; font-weight: 600; }
        .pc-tab.active { color: #333; border-bottom: 3px solid var(--p); }
        .search-trigger { margin-left: auto; width: 40px; height: 40px; border-radius: 50%; background: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: 0.2s; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        .m-header { display: none !important; }

        .feed { display: grid; gap: 20px; grid-template-columns: repeat(3, 1fr); }
        @media (min-width: 1600px) { .feed { grid-template-columns: repeat(4, 1fr); } }

        .card { background: var(--white); border-radius: 16px; overflow: hidden; text-decoration: none; color: var(--text); box-shadow: 0 2px 10px rgba(0,0,0,0.02); transition: all 0.3s ease; display: flex; flex-direction: column; position: relative; border: 1px solid transparent; }
        .card:hover { transform: translateY(-4px); box-shadow: 0 10px 25px rgba(0,0,0,0.08); border-color: rgba(0,0,0,0.05); }
        .card-cover { width: 100%; aspect-ratio: 3/4; object-fit: cover; background: #f9f9f9; }
        .text-card-cover { width: 100%; aspect-ratio: 3/4; padding: 25px; display: flex; align-items: center; justify-content: center; text-align: center; font-size: 16px; font-weight: bold; line-height: 1.6; color: #fff; position: relative; }
        .bg-1 { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); }
        .bg-2 { background: linear-gradient(135deg, #84fab0 0%, #8fd3f4 100%); }
        .bg-3 { background: linear-gradient(135deg, #a18cd1 0%, #fbc2eb 100%); }
        .bg-4 { background: linear-gradient(135deg, #ff9a9e 0%, #fecfef 99%, #fecfef 100%); }

        .card-info { padding: 14px; flex: 1; display: flex; flex-direction: column; justify-content: space-between; }
        .card-txt { font-size: 14px; line-height: 1.5; margin-bottom: 10px; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; font-weight: 500; color: #333; }
        .card-bot { display: flex; justify-content: space-between; align-items: center; font-size: 12px; color: #888; }
        .user-row { display: flex; align-items: center; gap: 6px; }
        .avatar { width: 20px; height: 20px; border-radius: 50%; object-fit: cover; border: 1px solid #eee; }
        .img-tag { position: absolute; top: 8px; right: 8px; background: rgba(0,0,0,0.5); color: #fff; padding: 2px 6px; border-radius: 10px; font-size: 10px; display: flex; align-items: center; gap: 3px; backdrop-filter: blur(2px); }

        .dock { display: none !important; }

        @media (max-width: 900px) {
            .app-container { display: block; }
            .sidebar { display: none !important; }
            .main-content { padding: 0 10px; margin: 0; }
            .top-bar-pc { display: none !important; }
            
            .m-header { display: flex !important; position: sticky; top: 0; z-index: 90; background: rgba(255,255,255,0.98); backdrop-filter: blur(10px); padding: 10px; justify-content: center; gap: 20px; border-bottom: 1px solid #eee; }
            .m-tab { font-size: 15px; color: #999; font-weight: bold; padding-bottom: 5px; cursor: pointer; white-space: nowrap; }
            .m-tab.active { color: #333; border-bottom: 3px solid var(--p); }
            .m-search-icon { position: absolute; right: 15px; top: 12px; font-size: 18px; color: #333; cursor: pointer; }
            
            .feed { grid-template-columns: 1fr 1fr; gap: 10px; padding-bottom: 70px; }
            
            .dock { display: flex !important; position: fixed; bottom: 0; left: 0; width: 100%; height: 55px; background: rgba(255,255,255,0.98); border-top: 1px solid #eee; justify-content: space-around; align-items: center; z-index: 1000; padding-bottom: env(safe-area-inset-bottom); }
            .dock-item { display: flex; flex-direction: column; align-items: center; color: #999; font-size: 10px; width: 20%; position: relative; }
            .dock-item.active { color: #333; font-weight: bold; }
            .dock-item svg { width: 24px; height: 24px; fill: currentColor; margin-bottom: 2px; }
            .pub-btn-m { background: var(--p); border-radius: 12px; width: 45px; height: 32px; display: flex; align-items: center; justify-content: center; }
            .pub-btn-m svg { fill: #fff; width: 20px; }
            .m-badge { position: absolute; top: 2px; left: 50%; margin-left: 6px; min-width: 16px; height: 16px; padding: 0 4px; background: #ff2442; color: #fff; font-size: 10px; border-radius: 10px; border: 2px solid #fff; display: flex; align-items: center; justify-content: center; z-index: 10; box-sizing: content-box; }
            
            .hot-grid { grid-template-columns: 1fr; }
            .hot-area { padding: 20px; }
        }

        .search-layer { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: #fff; z-index: 9999; display: none; flex-direction: column; }
        .search-header { display: flex; align-items: center; gap: 15px; padding: 15px 20px; border-bottom: 1px solid #f5f5f5; }
        .real-search-box { flex: 1; position: relative; }
        .real-search-inp { width: 100%; background: #f5f5f5; border: none; padding: 12px 15px 12px 40px; border-radius: 25px; font-size: 15px; color: #333; }
        .real-search-inp:focus { background: #fff; outline: 2px solid var(--p); }
        .search-icon-inside { position: absolute; left: 15px; top: 50%; transform: translateY(-50%); color: #999; }
        .btn-cancel { font-size: 15px; color: #666; cursor: pointer; font-weight: bold; }
        .hot-area { padding: 30px; max-width: 800px; margin: 0 auto; width: 100%; overflow-y: auto; }
        .hot-title { font-size: 14px; font-weight: bold; color: #333; margin-bottom: 20px; display: flex; align-items: center; gap: 5px; }
        .hot-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; }
        .hot-item { display: flex; align-items: center; gap: 10px; cursor: pointer; padding: 10px; border-radius: 8px; transition: 0.2s; }
        .hot-item:hover { background: #f9f9f9; }
        .rank-num { font-weight: 900; font-size: 16px; font-style: italic; width: 20px; text-align: center; }
        .rank-1 { color: #ff2442; } .rank-2 { color: #ff9f43; } .rank-3 { color: #feca57; } .rank-other { color: #ccc; }
        .hot-txt { font-size: 14px; color: #333; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }

        .modal-overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 99999; align-items: center; justify-content: center; }
        .modal-box { width: 500px; max-width: 90%; background: #fff; border-radius: 24px; padding: 25px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); display: flex; flex-direction: column; position: relative; max-height: 90vh; overflow-y: auto; }
        .modal-head { display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px; border-bottom: 1px solid #f5f5f5; padding-bottom: 15px; }
        .modal-title { font-size: 18px; font-weight: 900; color: #333; }
        .close-btn { font-size: 24px; color: #999; cursor: pointer; padding: 5px; }
        .pub-textarea { width: 100%; height: 120px; border: 1px solid #eee; background: #f9f9f9; font-size: 16px; color: #333; resize: none; margin-bottom: 15px; padding: 12px; border-radius: 12px; font-family: inherit; display: block; }
        .pub-textarea:focus { background: #fff; border-color: var(--p); }
        .media-grid { display: flex; flex-wrap: wrap; gap: 10px; margin-bottom: 20px; min-height: 80px; }
        .add-btn { width: 80px; height: 80px; border: 2px dashed #ddd; border-radius: 12px; display: flex; align-items: center; justify-content: center; cursor: pointer; color: #ccc; background: #fff; }
        .preview-item { width: 80px; height: 80px; border-radius: 12px; overflow: hidden; position: relative; border: 1px solid #eee; }
        .preview-item img { width: 100%; height: 100%; object-fit: cover; }
        .del-btn { position: absolute; top: 2px; right: 2px; background: rgba(0,0,0,0.6); color: #fff; width: 18px; height: 18px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; cursor: pointer; }
        .modal-foot { display: flex; justify-content: space-between; align-items: center; border-top: 1px solid #f5f5f5; padding-top: 15px; }
        .anon-switch { display: flex; align-items: center; gap: 8px; color: #666; font-size: 14px; cursor: pointer; }
        .switch { position: relative; display: inline-block; width: 40px; height: 22px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ddd; transition: .4s; border-radius: 34px; }
        .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 2px; bottom: 2px; background-color: white; transition: .4s; border-radius: 50%; box-shadow: 0 2px 5px rgba(0,0,0,0.2); }
        input:checked + .slider { background-color: var(--p); }
        input:checked + .slider:before { transform: translateX(18px); }
        .submit-btn { background: var(--p); color: #fff; border: none; padding: 10px 30px; border-radius: 20px; font-weight: bold; cursor: pointer; }
    </style>
</head>
<body>

<div class="search-layer" id="searchLayer">
    <div class="search-header">
        <div class="real-search-box">
            <i class="fa-solid fa-magnifying-glass search-icon-inside"></i>
            <input type="text" id="realSearchInput" class="real-search-inp" placeholder="搜索你感兴趣的内容..." value="<?= htmlspecialchars($q) ?>">
        </div>
        <div class="btn-cancel" onclick="closeSearch()">取消</div>
    </div>
    <div class="hot-area">
        <div class="hot-title"><i class="fa-solid fa-fire" style="color:#ff2442"></i> 全站热搜</div>
        <div class="hot-grid">
            <?php foreach($trending as $k => $txt): 
                $rank = $k + 1;
                $rankClass = $rank==1?'rank-1':($rank==2?'rank-2':($rank==3?'rank-3':'rank-other'));
                $cleanTxt = mb_substr(strip_tags($txt), 0, 15);
            ?>
            <div class="hot-item" onclick="location.href='?q=<?= urlencode($cleanTxt) ?>'">
                <div class="rank-num <?= $rankClass ?>"><?= $rank ?></div>
                <div class="hot-txt"><?= htmlspecialchars($cleanTxt) ?></div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<div class="app-container">
    <div class="sidebar">
        <div class="logo"><i class="fa-solid fa-layer-group"></i> <?= htmlspecialchars($siteName) ?></div>
        <nav class="nav-menu">
            <a href="index.php" class="nav-item active"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg> 发现</a>
            <a href="shop.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg> 商城</a>
            <a href="javascript:void(0)" onclick="tryLink('chat.php?to_id=0')" class="nav-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg> 聊天</a>
            <a href="javascript:void(0)" onclick="tryLink('message.php')" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z"/></svg> 消息 <?php if($unread_total>0):?><span class="pc-badge"><?=$unread_total?></span><?php endif; ?></a>
            <a href="javascript:void(0)" onclick="tryLink('user.php')" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg> <?= $currentUser?'我':'登录/注册' ?></a>
        </nav>
        <button class="btn-create" onclick="tryPub()"><i class="fa-solid fa-plus"></i> 发布图文</button>
    </div>

    <div class="main-content">
        <div class="top-bar-pc">
            <a href="?tab=follow" class="pc-tab <?= $tab=='follow'?'active':'' ?>">关注</a>
            <a href="?tab=discover" class="pc-tab <?= $tab=='discover'?'active':'' ?>">发现</a>
            <a href="?tab=same_city" class="pc-tab <?= $tab=='same_city'?'active':'' ?>">同城</a>
            <a href="?tab=rank" class="pc-tab <?= $tab=='rank'?'active':'' ?>">榜单</a>
            <div class="search-trigger" onclick="openSearch()"><i class="fa-solid fa-magnifying-glass"></i></div>
        </div>

        <div class="m-header">
            <a href="?tab=follow" class="m-tab <?= $tab=='follow'?'active':'' ?>">关注</a>
            <a href="?tab=discover" class="m-tab <?= $tab=='discover'?'active':'' ?>">发现</a>
            <a href="?tab=same_city" class="m-tab <?= $tab=='same_city'?'active':'' ?>">同城</a>
            <a href="?tab=rank" class="m-tab <?= $tab=='rank'?'active':'' ?>">榜单</a>
            <div class="m-search-icon" onclick="openSearch()"><i class="fa-solid fa-magnifying-glass"></i></div>
        </div>

        <div class="feed">
            <?php foreach($posts as $post): 
                // 🔥 核心修复：添加非空判断和类型转换
                $raw = $post['image_url'] ?? ''; 
                $clean = is_string($raw) ? stripslashes($raw) : ''; 
                $imgs = json_decode($clean, true);
                if (!is_array($imgs)) $imgs = (!empty($raw) && $raw != 'null') ? [trim($raw, '"')] : [];
                $imgs = array_filter($imgs);
                $cover = $imgs[0] ?? '';
                
                $isAnon = $post['is_anonymous'] == 1;
                $uName = $isAnon ? '某同学' : ($post['username'] ?: '显眼包');
                $uAvatar = $isAnon 
                    ? 'https://ui-avatars.com/api/?name=An&background=f0f0f0&color=999' 
                    : ($post['avatar'] ?: "https://ui-avatars.com/api/?name=$uName&background=random&color=fff");
                
                $bgClass = 'bg-' . rand(1, 4);
            ?>
            <a href="post.php?id=<?= $post['id'] ?>" class="card">
                <div style="position:relative;">
                    <?php if($cover): ?>
                        <img src="<?= htmlspecialchars($cover) ?>" class="card-cover" loading="lazy">
                        <?php if(count($imgs) > 1): ?><div class="img-tag"><i class="fa-solid fa-images"></i> <?= count($imgs) ?></div><?php endif; ?>
                    <?php else: ?>
                        <div class="text-card-cover <?= $bgClass ?>"><span><?= htmlspecialchars(mb_substr($post['content'], 0, 40)) ?></span></div>
                    <?php endif; ?>
                </div>
                <div class="card-info">
                    <div class="card-txt"><?= htmlspecialchars($post['content']) ?></div>
                    <div class="card-bot">
                        <div class="user-row"><img src="<?= $uAvatar ?>" class="avatar"><span><?= htmlspecialchars($uName) ?></span>
                        <?php if(!empty($post['title_text']) && !$isAnon): ?>
                            <span style="font-size:9px;padding:1px 4px;border-radius:4px;margin-left:4px;<?= $post['title_style'] ?>"><?= $post['title_text'] ?></span>
                        <?php endif; ?>
                        </div>
                        <div><i class="fa-regular fa-heart"></i> <?= $post['likes'] ?></div>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<nav class="dock">
    <a href="index.php" class="dock-item active"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>首页</a>
    <a href="shop.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg>商城</a>
    <div class="dock-item" onclick="tryPub()"><div class="pub-btn-m"><i class="fa-solid fa-plus" style="color:#fff;"></i></div></div>
    <a href="javascript:void(0)" onclick="tryLink('chat.php?to_id=0')" class="dock-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg><?php if($unread_total>0): ?><div class="m-badge"><?= $unread_total>99?'99+':$unread_total ?></div><?php endif; ?>消息</a>
    <a href="javascript:void(0)" onclick="tryLink('user.php')" class="dock-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg>我</a>
</nav>

<div class="modal-overlay" id="pubModal" onclick="if(event.target===this) closePub()">
    <div class="modal-box">
        <div class="modal-head">
            <div class="modal-title">分享此刻</div>
            <div class="close-btn" onclick="closePub()">&times;</div>
        </div>
        <form id="pubForm">
            <textarea name="content" class="pub-textarea" placeholder="这一刻的想法..."></textarea>
            
            <div class="media-grid" id="preBox">
                <label class="add-btn">
                    <input type="file" name="image[]" multiple accept="image/*" style="display:none" onchange="handleFiles(this)">
                    <i class="fa-solid fa-plus" style="font-size:24px;"></i>
                </label>
            </div>
            
            <div class="modal-foot">
                <label class="anon-switch">
                    <label class="switch">
                        <input type="checkbox" id="anonCheck">
                        <span class="slider"></span>
                    </label>
                    <span>匿名发布</span>
                </label>
                <button type="submit" class="submit-btn" id="subBtn">发布</button>
            </div>
        </form>
    </div>
</div>

<script>
    const isLogin = <?= $currentUser ? 'true' : 'false' ?>;

    function tryPub() {
        if (!isLogin) {
            if(confirm('发布内容需要登录，是否去登录？')) location.href = 'login.php';
            return;
        }
        openPub(); 
    }

    function tryLink(url) {
        if (!isLogin) {
            location.href = 'login.php';
            return;
        }
        location.href = url;
    }

    // 搜索
    function openSearch() { document.getElementById('searchLayer').style.display='flex'; setTimeout(()=>document.getElementById('realSearchInput').focus(),100); }
    function closeSearch() { document.getElementById('searchLayer').style.display='none'; }
    document.getElementById('realSearchInput').onkeypress = function(e){ if(e.key==='Enter') location.href='?q='+encodeURIComponent(this.value); }

    // 发布弹窗
    const pubModal = document.getElementById('pubModal');
    function openPub() { 
        pubModal.style.display = 'flex'; 
        setTimeout(() => { document.querySelector('.pub-textarea').focus(); }, 100);
    }
    function closePub() { pubModal.style.display = 'none'; }

    let filesList = [];
    function handleFiles(input) {
        filesList = filesList.concat(Array.from(input.files));
        render(); input.value = '';
    }
    function render() {
        const box = document.getElementById('preBox');
        const btn = box.lastElementChild; 
        while(box.children.length > 1) { box.removeChild(box.firstChild); }
        filesList.forEach((f, i) => {
            const r = new FileReader();
            r.onload = e => {
                const div = document.createElement('div'); div.className='preview-item';
                div.innerHTML = `<img src="${e.target.result}"><div class="del-btn" onclick="delImg(${i})">&times;</div>`;
                box.insertBefore(div, btn);
            };
            r.readAsDataURL(f);
        });
    }
    window.delImg = i => { filesList.splice(i, 1); render(); };

    document.getElementById('pubForm').onsubmit = function(e) {
        e.preventDefault();
        const btn = document.getElementById('subBtn');
        const txt = this.content.value.trim();
        const anon = document.getElementById('anonCheck').checked ? 1 : 0;
        if(!txt && filesList.length===0) { alert('内容不能为空'); return; }
        btn.innerText = '发布中...'; btn.disabled = true;
        const fd = new FormData();
        fd.append('content', txt); fd.append('is_anonymous', anon);
        filesList.forEach(f => fd.append('image[]', f));
        fetch('submit.php', { method:'POST', body:fd }).then(r=>r.json()).then(res=>{
            if(res.status==='success') location.reload();
            else { alert(res.msg); btn.innerText='发布'; btn.disabled=false; }
        });
    }
</script>
</body>
</html>