<?php
/**
 * install.php - Slice社区 v22.0 完美修正版
 * 1. 修正：默认植入 2-3 字短称号 (萌新/大佬/卷王等)
 * 2. 确认：数据库结构完全适配 v27.0 (含DIY背景/扫码/分享)
 * 3. 视觉：暗黑科技风 UI
 */

// 1. 基础设置
ini_set('display_errors', 1);
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
set_time_limit(300);
header("Content-Type: text/html; charset=utf-8");

// 2. 预检逻辑
$step = 'form';
$sys_errors = [];
if (!is_writable('.')) $sys_errors[] = "根目录无写入权限 (需 777 或 755)";
if (!extension_loaded('pdo_mysql')) $sys_errors[] = "缺失 PDO_MYSQL 扩展";
if (!extension_loaded('curl')) $sys_errors[] = "缺失 CURL 扩展 (用于授权验证)";

$is_installed = (file_exists('license.lock') && file_exists('db.php'));

if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($sys_errors) && !$is_installed) {
    $step = 'install';
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>系统初始化 | Slice System</title>
    <style>
        /* 🔥 暗黑科技风格 */
        :root { --bg: #050505; --card: rgba(30, 30, 30, 0.6); --primary: #7000ff; --accent: #00ffcc; --text: #eee; --err: #ff4444; }
        * { box-sizing: border-box; outline: none; }
        body { 
            margin: 0; font-family: 'Inter', -apple-system, sans-serif; 
            background-color: var(--bg); 
            background-image: radial-gradient(circle at 50% 0%, #1a0b2e 0%, #000 60%);
            color: var(--text); min-height: 100vh; display: flex; align-items: center; justify-content: center; 
        }
        .container { width: 100%; max-width: 480px; padding: 20px; animation: fadeIn 0.8s ease-out; }
        .glass-panel { background: var(--card); backdrop-filter: blur(20px); -webkit-backdrop-filter: blur(20px); border: 1px solid rgba(255,255,255,0.1); border-radius: 24px; padding: 40px; box-shadow: 0 20px 80px rgba(0,0,0,0.6); }
        .header { text-align: center; margin-bottom: 30px; }
        .logo { font-size: 32px; font-weight: 900; letter-spacing: -1px; margin-bottom: 5px; }
        .logo span { background: linear-gradient(135deg, var(--primary), var(--accent)); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
        .form-group { margin-bottom: 18px; }
        .label { display: block; font-size: 12px; color: #888; margin-bottom: 8px; font-weight: 600; margin-left: 4px; }
        .input-field { width: 100%; background: rgba(0,0,0,0.3); border: 1px solid rgba(255,255,255,0.1); color: #fff; padding: 14px 16px; border-radius: 12px; font-size: 14px; transition: 0.3s; }
        .input-field:focus { border-color: var(--primary); background: rgba(0,0,0,0.5); }
        .btn-submit { width: 100%; background: linear-gradient(90deg, var(--primary), #5a00d6); color: #fff; border: none; padding: 16px; border-radius: 12px; font-size: 16px; font-weight: bold; cursor: pointer; margin-top: 10px; transition: 0.3s; }
        .btn-submit:hover { opacity: 0.9; transform: translateY(-2px); box-shadow: 0 10px 20px rgba(112, 0, 255, 0.3); }
        .terminal { background: #000; border-radius: 12px; padding: 20px; font-family: monospace; font-size: 13px; color: #ccc; height: 350px; overflow-y: auto; border: 1px solid #333; }
        .log-line { margin-bottom: 5px; border-bottom: 1px solid #111; padding-bottom: 2px; } 
        .log-success { color: var(--accent); } .log-error { color: var(--err); } .log-info { color: #aaa; }
        @keyframes fadeIn { from { opacity:0; transform:translateY(20px); } to { opacity:1; transform:translateY(0); } }
    </style>
</head>
<body>

<div class="container">
    <div class="glass-panel">
        <div class="header"><div class="logo">SLICE <span>DEPLOY</span></div></div>

        <?php if (!empty($sys_errors)): ?>
            <div style="color:var(--err);text-align:center;">
                <h3>Environment Check Failed</h3>
                <?= implode('<br>', $sys_errors) ?>
            </div>
        <?php elseif ($is_installed): ?>
            <div style="text-align:center">
                <h3>System Locked</h3>
                <p style="color:#888;font-size:14px;">已检测到 license.lock 文件。</p>
                <a href="index.php" class="btn-submit" style="display:block;text-decoration:none;text-align:center;">前往首页</a>
            </div>
        <?php elseif ($step === 'form'): ?>
            <form method="post">
                <div class="form-group"><label class="label">SITE NAME</label><input type="text" name="site_name" class="input-field" value="Slice社区"></div>
                <div class="form-group"><label class="label">LICENSE KEY</label><input type="text" name="license" class="input-field" placeholder="请输入正版授权码" required></div>
                <div style="height:1px;background:rgba(255,255,255,0.1);margin:25px 0"></div>
                <div class="form-group"><label class="label">DB HOST</label><input type="text" name="db_host" class="input-field" value="127.0.0.1" required></div>
                <div class="form-group"><label class="label">DB NAME</label><input type="text" name="db_name" class="input-field" required></div>
                <div class="form-group"><label class="label">DB USER</label><input type="text" name="db_user" class="input-field" required></div>
                <div class="form-group"><label class="label">DB PASS</label><input type="password" name="db_pass" class="input-field"></div>
                <button type="submit" class="btn-submit">INITIALIZE SYSTEM</button>
            </form>
        <?php elseif ($step === 'install'): ?>
            <div class="terminal" id="console">
                <?php
                function logMsg($msg, $type='info') {
                    $c = $type=='success'?'log-success':($type=='error'?'log-error':'log-info');
                    echo "<div class='log-line'>[".date('H:i:s')."] <span class='$c'>$msg</span></div>"; 
                    ob_flush(); flush();
                }
                
                $db_host = trim($_POST['db_host']); 
                $db_user = trim($_POST['db_user']); 
                $db_pass = trim($_POST['db_pass']); 
                $db_name = trim($_POST['db_name']); 
                $license = trim($_POST['license']); 
                $site_name = trim($_POST['site_name']);
                $success = false;

                try {
                    // 1. 验证数据库连接
                    logMsg("正在连接数据库...", "info");
                    $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
                    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    logMsg("数据库连接成功", "success");

                    // 2. 远程授权验证
                    logMsg("正在连接授权服务器...", "info");
                    $verify_url = "http://source.ictcode.com/verify_license.php";
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $verify_url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                        'key' => $license,
                        'domain' => $_SERVER['HTTP_HOST'],
                        'ip' => $_SERVER['REMOTE_ADDR']
                    ]));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
                    $response = curl_exec($ch);
                    $curl_error = curl_error($ch);
                    curl_close($ch);

                    if ($curl_error) throw new Exception("授权服务器连接失败: " . $curl_error);

                    $res_json = json_decode($response, true);
                    if (!$res_json || $res_json['status'] !== 'success') {
                        $err_msg = $res_json['msg'] ?? '授权码无效或已被禁用';
                        throw new Exception("🚫 授权验证失败: " . $err_msg);
                    }
                    logMsg("✅ 正版授权验证通过", "success");

                    // 3. 写入配置文件
                    logMsg("生成配置文件 db.php...", "info");
                    $db_content = "<?php
\$servername = '$db_host'; \$username = '$db_user'; \$password = '$db_pass'; \$dbname = '$db_name';
try { \$conn = new PDO(\"mysql:host=\$servername;dbname=\$dbname;charset=utf8mb4\", \$username, \$password);
\$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); \$conn->exec(\"SET NAMES utf8mb4\"); }
catch(PDOException \$e) { die(\"Database Error\"); }
function get_setting(\$key, \$default = '') { global \$conn; try { \$stmt = \$conn->prepare(\"SELECT config_value FROM settings WHERE config_key = ?\");
\$stmt->execute([\$key]); \$val = \$stmt->fetchColumn(); return \$val !== false ? \$val : \$default; } catch (Exception \$e) { return \$default; } } ?>";
                    
                    if (file_put_contents('db.php', $db_content) === false) throw new Exception("db.php 写入失败，请检查目录权限");

                    // 4. 初始化数据表
                    logMsg("初始化数据表结构...", "info");
                    $sqls = [
                        "SET NAMES utf8mb4", 
                        "SET FOREIGN_KEY_CHECKS = 0",
                        // 用户表 (含 password, points, background)
                        "CREATE TABLE IF NOT EXISTS users (
                            id INT AUTO_INCREMENT PRIMARY KEY, 
                            token VARCHAR(64) UNIQUE, 
                            username VARCHAR(50) UNIQUE, 
                            password VARCHAR(255), 
                            avatar VARCHAR(255), 
                            city VARCHAR(100) DEFAULT '未知', 
                            points INT DEFAULT 100,
                            background VARCHAR(255),
                            bio VARCHAR(255), 
                            role ENUM('user','admin') DEFAULT 'user', 
                            status ENUM('active', 'banned') DEFAULT 'active', 
                            last_active TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, 
                            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, 
                            INDEX(token)
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 资产表 (称号/背景)
                        "CREATE TABLE IF NOT EXISTS assets (
                            id INT AUTO_INCREMENT PRIMARY KEY,
                            name VARCHAR(50),
                            type ENUM('title', 'bg') NOT NULL,
                            value VARCHAR(255) NOT NULL,
                            style VARCHAR(255) DEFAULT '',
                            price INT DEFAULT 0,
                            icon VARCHAR(255) DEFAULT '',
                            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 用户资产关联表
                        "CREATE TABLE IF NOT EXISTS user_assets (
                            id INT AUTO_INCREMENT PRIMARY KEY,
                            user_id INT,
                            asset_id INT,
                            is_equipped TINYINT(1) DEFAULT 0,
                            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                            INDEX(user_id)
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 管理员
                        "CREATE TABLE IF NOT EXISTS admins (id INT AUTO_INCREMENT PRIMARY KEY, username VARCHAR(50) UNIQUE, password VARCHAR(255), created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 帖子
                        "CREATE TABLE IF NOT EXISTS posts (id INT AUTO_INCREMENT PRIMARY KEY, user_id INT, content TEXT, image_url TEXT, likes INT DEFAULT 0, is_anonymous TINYINT(1) DEFAULT 0, is_pinned TINYINT(1) DEFAULT 0, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, INDEX(user_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 评论
                        "CREATE TABLE IF NOT EXISTS comments (id INT AUTO_INCREMENT PRIMARY KEY, post_id INT, user_id INT, parent_id INT DEFAULT 0, username VARCHAR(50), content TEXT, likes INT DEFAULT 0, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, INDEX(post_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 聊天
                        "CREATE TABLE IF NOT EXISTS chat (id INT AUTO_INCREMENT PRIMARY KEY, from_user_id INT, to_user_id INT DEFAULT 0, username VARCHAR(50), avatar VARCHAR(255), message TEXT, is_read TINYINT(1) DEFAULT 0, type VARCHAR(20) DEFAULT 'text', ref_id INT DEFAULT 0, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, INDEX(from_user_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 商品
                        "CREATE TABLE IF NOT EXISTS products (id INT AUTO_INCREMENT PRIMARY KEY, user_id INT NOT NULL, title VARCHAR(255), price DECIMAL(10,2), description TEXT, image_url TEXT, status TINYINT DEFAULT 1, likes INT DEFAULT 0, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, INDEX(user_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        // 关联表
                        "CREATE TABLE IF NOT EXISTS post_likes (id INT AUTO_INCREMENT PRIMARY KEY, user_id INT, post_id INT, UNIQUE KEY(user_id, post_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        "CREATE TABLE IF NOT EXISTS comment_likes (id INT AUTO_INCREMENT PRIMARY KEY, user_id INT NOT NULL, comment_id INT NOT NULL, UNIQUE KEY(user_id, comment_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        "CREATE TABLE IF NOT EXISTS notifications (id INT AUTO_INCREMENT PRIMARY KEY, receiver_id INT, sender_id INT, type ENUM('like','follow','comment','system','chat'), post_id INT DEFAULT 0, content TEXT, is_read TINYINT(1) DEFAULT 0, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        "CREATE TABLE IF NOT EXISTS follows (id INT AUTO_INCREMENT PRIMARY KEY, follower_id INT, following_id INT, UNIQUE KEY(follower_id, following_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        "CREATE TABLE IF NOT EXISTS settings (config_key VARCHAR(50) PRIMARY KEY, config_value TEXT) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
                        
                        // 初始化系统数据
                        "INSERT IGNORE INTO settings VALUES ('site_name', '$site_name'), ('site_notice', '欢迎来到Slice社区'), ('allow_anonymous', '1'), ('ai_comment_open','0'), ('ai_chat_open','0')",
                        "INSERT IGNORE INTO admins (username, password) VALUES ('admin', '" . password_hash('123456', PASSWORD_DEFAULT) . "')",
                        
                        // 🔥 初始化商城数据 (修正为 2-3字 短称号)
                        "INSERT IGNORE INTO assets (name, type, value, style, price, icon) VALUES 
                        ('萌新', 'title', '萌新', 'background:#e0e0e0;color:#999;font-size:10px', 0, ''),
                        ('社牛', 'title', '社牛', 'background:linear-gradient(90deg,#ff9a9e,#fecfef);color:#fff;font-weight:bold', 50, ''),
                        ('社恐', 'title', '社恐', 'background:#444;color:#fff;font-size:10px', 50, ''),
                        ('话痨', 'title', '话痨', 'background:#00d2ff;color:#fff', 100, ''),
                        ('大佬', 'title', '大佬', 'background:linear-gradient(90deg,#30cfd0,#330867);color:#fff;font-weight:bold', 200, ''),
                        ('欧皇', 'title', '欧皇', 'background:linear-gradient(90deg,#f6d365,#fda085);color:#fff;font-weight:bold', 300, ''),
                        ('非酋', 'title', '非酋', 'background:#555;color:#ccc', 100, ''),
                        ('海王', 'title', '海王', 'background:linear-gradient(90deg,#4facfe,#00f2fe);color:#fff', 500, ''),
                        ('纯爱', 'title', '纯爱', 'background:#ff758c;color:#fff', 500, ''),
                        ('卷王', 'title', '卷王', 'background:#000;color:#0f0;border:1px solid #0f0', 666, ''),
                        ('躺平', 'title', '躺平', 'background:#a8edea;color:#555', 50, ''),
                        ('颜狗', 'title', '颜狗', 'background:#ff9a9e;color:#fff', 200, ''),
                        ('锦鲤', 'title', '锦鲤', 'background:linear-gradient(to right, #ffecd2 0%, #fcb69f 100%);color:#d35400;font-weight:bold', 888, ''),
                        ('富豪', 'title', '富豪', 'background:linear-gradient(90deg,#ffd700,#fdb931);color:#8a6e00;font-weight:900;box-shadow:0 2px 5px rgba(255,215,0,0.4)', 999, ''),
                        ('管理', 'title', '管理', 'background:#ff2442;color:#fff;border-radius:4px', 9999, ''),
                        
                        ('极简灰', 'bg', '#f8f8f8', '', 0, ''),
                        ('粉色心情', 'bg', 'linear-gradient(120deg, #a1c4fd 0%, #c2e9fb 100%)', '', 100, ''),
                        ('暗黑模式', 'bg', 'linear-gradient(to top, #09203f 0%, #537895 100%)', '', 150, ''),
                        ('星空', 'bg', 'linear-gradient(to right, #434343 0%, black 100%)', '', 300, '')"
                    ];
                    
                    foreach ($sqls as $sql) $conn->exec($sql);
                    logMsg("数据表创建完成 (含积分商城与短称号)", "success");

                    file_put_contents('license.lock', "KEY: $license");
                    logMsg("🎉 系统安装成功！", "success");
                    $success = true;

                } catch (Exception $e) { 
                    logMsg("❌ 安装中断: " . $e->getMessage(), "error"); 
                    if(file_exists('db.php')) unlink('db.php');
                }
                ?>
            </div>
            
            <?php if ($success): ?>
                <div style="margin-top:20px;text-align:center;animation:fadeIn 1s;">
                    <a href="index.php" class="btn-submit" style="display:block;text-decoration:none;text-align:center;">进入前台首页</a>
                    <div style="margin-top:10px;font-size:12px;color:#888;">
                        后台地址: <a href="admin_login.php" style="color:var(--accent)">/admin_login.php</a> <br>
                        默认账号: admin / 123456
                    </div>
                </div>
            <?php else: ?>
                <div style="margin-top:20px;text-align:center">
                    <button onclick="history.back()" style="background:transparent;border:1px solid #666;color:#ccc;padding:10px 20px;border-radius:8px;cursor:pointer;">返回重试</button>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
</body>
</html>