<?php
/**
 * ip_helper.php - 独立的 IP 属地解析工具
 * 功能：获取真实IP，并调用接口解析城市
 */

// 1. 获取用户真实 IP
function get_real_ip() {
    $ip = $_SERVER['REMOTE_ADDR'];
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) $ip = $_SERVER['HTTP_CF_CONNECTING_IP']; // Cloudflare
    elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    return $ip;
}

// 2. IP 转城市 (调用 ip-api.com 免费接口)
function get_city_by_ip($ip) {
    // 本地开发环境特判
    if ($ip == '127.0.0.1' || $ip == '::1' || strpos($ip, '192.168.') === 0) {
        return '本地开发';
    }
    
    // 使用 ip-api.com 接口 (支持中文)
    $url = "http://ip-api.com/json/$ip?lang=zh-CN";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 2); // 设置2秒超时，防止接口挂了卡住整个网站
    $res = curl_exec($ch);
    curl_close($ch);
    
    if ($res) {
        $data = json_decode($res, true);
        if (isset($data['status']) && $data['status'] == 'success') {
            $region = $data['regionName'];
            $city = $data['city'];
            // 如果省份和城市名一样（如北京北京），只显示一个
            if ($region == $city) return $region;
            return $region . ' ' . $city;
        }
    }
    return '未知星球'; // 接口失败时的默认值
}
?>