<?php
require 'db.php';
$siteName = get_setting('site_name', 'Slice社区');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>登录 - <?= htmlspecialchars($siteName) ?></title>
    <style>
        :root { --p: #ff2442; --bg: #f8f8f8; }
        * { box-sizing: border-box; margin: 0; padding: 0; outline: none; -webkit-tap-highlight-color: transparent; }
        body { 
            background: url('https://source.ictcode.com/images/login_bg_blur.jpg') no-repeat center center fixed; 
            background-size: cover;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; 
            height: 100vh; display: flex; align-items: center; justify-content: center;
        }
        body::before { content:''; position:absolute; inset:0; background: rgba(255,255,255,0.3); backdrop-filter: blur(10px); z-index:-1; }

        .login-card {
            background: rgba(255, 255, 255, 0.95);
            width: 400px; max-width: 90%;
            border-radius: 24px;
            padding: 40px 30px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.1);
            text-align: center;
            position: relative;
            overflow: hidden;
            animation: popUp 0.5s ease;
        }
        
        .logo { font-size: 32px; font-weight: 900; color: var(--p); margin-bottom: 10px; display: inline-block; letter-spacing: -1px; }
        .slogan { font-size: 14px; color: #999; margin-bottom: 30px; font-weight: 500; }

        .tab-box { display: flex; justify-content: center; gap: 30px; margin-bottom: 30px; position: relative; }
        .tab-item { font-size: 16px; color: #999; cursor: pointer; font-weight: bold; padding-bottom: 5px; transition: 0.3s; }
        .tab-item.active { color: #333; font-size: 18px; border-bottom: 3px solid var(--p); }

        .inp-group { margin-bottom: 20px; }
        .inp { width: 100%; padding: 15px 20px; background: #f5f5f5; border: 1px solid transparent; border-radius: 30px; font-size: 15px; transition: 0.3s; }
        .inp:focus { background: #fff; border-color: var(--p); box-shadow: 0 0 0 4px rgba(255,36,66,0.1); }

        .btn-submit {
            width: 100%; padding: 15px; border-radius: 30px; border: none;
            background: var(--p); color: #fff; font-size: 16px; font-weight: bold;
            cursor: pointer; box-shadow: 0 5px 20px rgba(255, 36, 66, 0.3);
            transition: 0.2s; margin-top: 10px;
        }
        .btn-submit:active { transform: scale(0.98); }
        .btn-submit:disabled { opacity: 0.7; cursor: not-allowed; }
        
        .tips { margin-top: 20px; font-size: 12px; color: #ccc; }
        .tips a { color: var(--p); text-decoration: none; }

        .form-view { display: none; animation: fadeIn 0.3s ease; }
        .form-view.active { display: block; }

        @keyframes popUp { from { opacity: 0; transform: scale(0.9) translateY(20px); } to { opacity: 1; transform: scale(1) translateY(0); } }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
    </style>
</head>
<body>

<div class="login-card">
    <div class="logo">SLICE</div>
    <div class="slogan">发现真实有趣的世界</div>

    <div class="tab-box">
        <div class="tab-item active" onclick="switchTab('login')">密码登录</div>
        <div class="tab-item" onclick="switchTab('register')">新用户注册</div>
    </div>

    <div id="loginView" class="form-view active">
        <form onsubmit="doAuth(event, 'login')">
            <div class="inp-group"><input type="text" name="username" class="inp" placeholder="请输入账号 / 昵称" required></div>
            <div class="inp-group"><input type="password" name="password" class="inp" placeholder="请输入密码" required></div>
            <button type="submit" class="btn-submit">登 录</button>
        </form>
    </div>

    <div id="regView" class="form-view">
        <form onsubmit="doAuth(event, 'register')">
            <div class="inp-group"><input type="text" name="username" class="inp" placeholder="设置一个好听的昵称" required></div>
            <div class="inp-group"><input type="password" name="password" class="inp" placeholder="设置登录密码 (至少6位)" required minlength="6"></div>
            <button type="submit" class="btn-submit">立即注册</button>
        </form>
    </div>

    <div class="tips">登录即代表同意 <a href="#">用户协议</a> 和 <a href="#">隐私政策</a></div>
</div>

<script>
    function switchTab(type) {
        document.querySelectorAll('.tab-item').forEach(el => el.classList.remove('active'));
        document.querySelectorAll('.form-view').forEach(el => el.classList.remove('active'));
        if (type === 'login') {
            document.querySelectorAll('.tab-item')[0].classList.add('active');
            document.getElementById('loginView').classList.add('active');
        } else {
            document.querySelectorAll('.tab-item')[1].classList.add('active');
            document.getElementById('regView').classList.add('active');
        }
    }

    function doAuth(e, action) {
        e.preventDefault();
        const form = e.target;
        const btn = form.querySelector('button');
        const user = form.username.value.trim();
        const pass = form.password.value.trim();
        
        if (!user || !pass) return alert('请填写完整信息');
        
        const originalText = btn.innerText;
        btn.innerText = '处理中...'; btn.disabled = true;

        const fd = new FormData();
        fd.append('action', action);
        fd.append('username', user);
        fd.append('password', pass);

        fetch('auth.php', { method: 'POST', body: fd })
            .then(r => r.json())
            .then(res => {
                if (res.status === 'success') {
                    btn.style.background = '#10b981';
                    btn.innerText = '成功跳转中...';
                    setTimeout(() => location.href = 'index.php', 800);
                } else {
                    alert(res.msg);
                    btn.innerText = originalText; btn.disabled = false;
                }
            })
            .catch(() => {
                alert('网络错误');
                btn.innerText = originalText; btn.disabled = false;
            });
    }
</script>
</body>
</html>