<?php
/**
 * message.php - v25.0 仿小红书聚合消息版
 * 1. 结构大改：顶部(赞/关注/评论) + 底部(私信列表)
 * 2. 支持点击顶部图标进入具体的通知列表页
 * 3. 完美整合了通知与聊天功能
 */
require 'db.php';

$token = $_COOKIE['xyb_token'] ?? '';
$currentUser = null;
if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $currentUser = $stmt->fetch(PDO::FETCH_ASSOC);
}
if (!$currentUser) { header("Location: login.php"); exit; }

$myId = $currentUser['id'];
$boxType = $_GET['box'] ?? ''; // 空=主页, like=赞, follow=关注, comment=评论

// ==========================================
// 模式 A: 显示具体的通知列表 (点赞/关注/评论)
// ==========================================
if ($boxType) {
    // 1. 标记该类型的通知为已读
    $map = ['like'=>'like', 'follow'=>'follow', 'comment'=>'comment'];
    $dbType = $map[$boxType] ?? '';
    if ($dbType) {
        $conn->query("UPDATE notifications SET is_read=1 WHERE receiver_id=$myId AND type='$dbType'");
        
        // 2. 获取列表
        $sql = "SELECT n.*, u.username, u.avatar 
                FROM notifications n 
                LEFT JOIN users u ON n.sender_id = u.id 
                WHERE n.receiver_id = $myId AND n.type = ? 
                ORDER BY n.created_at DESC LIMIT 50";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$dbType]);
        $list = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    // 标题映射
    $titles = ['like'=>'收到的赞', 'follow'=>'新增关注', 'comment'=>'收到的评论'];
    $title = $titles[$boxType] ?? '通知';
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?= $title ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { margin:0; font-family:-apple-system, sans-serif; background:#fff; color:#333; }
        .header { padding:15px; border-bottom:1px solid #eee; display:flex; align-items:center; gap:10px; font-weight:bold; position:sticky; top:0; background:#fff; z-index:10; }
        .item { display:flex; padding:15px; gap:12px; border-bottom:1px solid #f9f9f9; cursor:pointer; }
        .avatar { width:40px; height:40px; border-radius:50%; object-fit:cover; border:1px solid #eee; }
        .content { flex:1; }
        .name { font-weight:bold; font-size:14px; margin-bottom:4px; }
        .desc { font-size:14px; color:#666; }
        .date { font-size:12px; color:#ccc; margin-top:4px; }
        .post-cover { width:40px; height:40px; background:#f0f0f0; border-radius:4px; flex-shrink:0; object-fit:cover; }
    </style>
</head>
<body>
    <div class="header">
        <i class="fa-solid fa-arrow-left" onclick="history.back()" style="font-size:18px;padding:5px;cursor:pointer;"></i>
        <?= $title ?>
    </div>
    <?php if(empty($list)): ?>
        <div style="text-align:center;color:#ccc;padding:50px;">暂无消息</div>
    <?php else: ?>
        <?php foreach($list as $n): 
            $link = ($n['type'] == 'follow') ? "user.php?id={$n['sender_id']}" : "post.php?id={$n['post_id']}";
        ?>
        <div class="item" onclick="location.href='<?= $link ?>'">
            <img src="<?= $n['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="avatar">
            <div class="content">
                <div class="name"><?= htmlspecialchars($n['username']) ?></div>
                <div class="desc">
                    <?php 
                    if($n['type']=='like') echo '赞了你的笔记';
                    elseif($n['type']=='follow') echo '关注了你';
                    else echo '评论：' . htmlspecialchars($n['content']);
                    ?>
                </div>
                <div class="date"><?= date('m-d H:i', strtotime($n['created_at'])) ?></div>
            </div>
            <?php if($n['post_id']): ?>
                <div class="post-cover"></div>
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
</body>
</html>
<?php
    exit; // 结束执行，不显示下面的主页
}

// ==========================================
// 模式 B: 消息聚合主页 (Dashboard)
// ==========================================

// 1. 获取未读通知数 (分类统计)
$unreads = ['like'=>0, 'follow'=>0, 'comment'=>0];
$stats = $conn->query("SELECT type, COUNT(*) as c FROM notifications WHERE receiver_id=$myId AND is_read=0 GROUP BY type")->fetchAll(PDO::FETCH_ASSOC);
foreach($stats as $s) {
    if(isset($unreads[$s['type']])) $unreads[$s['type']] = $s['c'];
}

// 2. 获取私信列表 (逻辑同 chat.php)
$chats = [];
// 查找最近联系人 (排除公共频道)
$sql = "SELECT 
            CASE WHEN from_user_id = $myId THEN to_user_id ELSE from_user_id END as uid,
            MAX(created_at) as last_time,
            (SELECT message FROM chat WHERE id = MAX(c.id)) as last_msg,
            (SELECT count(*) FROM chat WHERE from_user_id = uid AND to_user_id = $myId AND is_read=0) as unread
        FROM chat c
        WHERE (from_user_id = $myId OR to_user_id = $myId) AND to_user_id != 0 
        GROUP BY uid 
        ORDER BY last_time DESC";
$chat_rows = $conn->query($sql)->fetchAll(PDO::FETCH_ASSOC);

foreach($chat_rows as $row) {
    $u = $conn->query("SELECT id, username, avatar FROM users WHERE id = {$row['uid']}")->fetch(PDO::FETCH_ASSOC);
    if($u) {
        $u['last_msg'] = $row['last_msg'];
        $u['last_time'] = $row['last_time'];
        $u['unread'] = $row['unread'];
        $chats[] = $u;
    }
}

$siteName = get_setting('site_name', 'Slice');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>消息 - <?= htmlspecialchars($siteName) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --p: #ff2442; --bg: #fff; --text: #333; }
        * { box-sizing: border-box; margin:0; padding:0; outline:none; -webkit-tap-highlight-color: transparent; }
        body { background: #fff; font-family: -apple-system, sans-serif; padding-bottom: 70px; color: var(--text); }

        .header { padding: 15px 20px; font-size: 18px; font-weight: 900; position: sticky; top: 0; background: #fff; z-index: 10; text-align: center; border-bottom: 1px solid #f5f5f5; }

        /* 顶部三个功能区 */
        .top-grid { display: flex; justify-content: space-around; padding: 20px 10px; border-bottom: 10px solid #f8f8f8; }
        .grid-item { display: flex; flex-direction: column; align-items: center; gap: 8px; cursor: pointer; position: relative; width: 30%; }
        .icon-box { width: 50px; height: 50px; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 24px; color: #fff; box-shadow: 0 4px 10px rgba(0,0,0,0.1); position: relative; }
        .grid-label { font-size: 13px; font-weight: bold; color: #333; }
        
        /* 红点 */
        .badge { position: absolute; top: -5px; right: -5px; background: var(--p); color: #fff; font-size: 10px; padding: 2px 6px; border-radius: 10px; border: 2px solid #fff; font-weight: bold; }

        /* 私信列表 */
        .chat-list { padding: 0 15px; }
        .list-title { font-size: 14px; color: #999; margin: 15px 0 10px; font-weight: bold; }
        .chat-item { display: flex; align-items: center; padding: 15px 0; border-bottom: 1px solid #f9f9f9; cursor: pointer; }
        .c-avt { width: 48px; height: 48px; border-radius: 50%; object-fit: cover; margin-right: 12px; border: 1px solid #eee; position: relative; }
        .c-info { flex: 1; min-width: 0; }
        .c-top { display: flex; justify-content: space-between; margin-bottom: 4px; }
        .c-name { font-weight: bold; font-size: 15px; }
        .c-time { font-size: 11px; color: #ccc; }
        .c-msg { font-size: 13px; color: #999; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        
        .avt-box { position: relative; }
        .unread-dot { position: absolute; top: 0; right: 0; width: 10px; height: 10px; background: var(--p); border-radius: 50%; border: 2px solid #fff; }

        .dock { display: flex; position: fixed; bottom: 0; width: 100%; height: 55px; background: #fff; border-top: 1px solid #eee; justify-content: space-around; align-items: center; z-index: 100; padding-bottom: env(safe-area-inset-bottom); }
        .dock-item { display: flex; flex-direction: column; align-items: center; color: #999; font-size: 10px; text-decoration: none; width: 20%; }
        .dock-item.active { color: #333; font-weight: bold; }
        .dock-item svg { width: 24px; height: 24px; fill: currentColor; margin-bottom: 2px; }
    </style>
</head>
<body>

<div class="header">消息</div>

<div class="top-grid">
    <div class="grid-item" onclick="location.href='?box=like'">
        <div class="icon-box" style="background:linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%);color:#ff2442;">
            <i class="fa-solid fa-heart"></i>
            <?php if($unreads['like']>0): ?><div class="badge"><?= $unreads['like'] ?></div><?php endif; ?>
        </div>
        <div class="grid-label">赞和收藏</div>
    </div>
    <div class="grid-item" onclick="location.href='?box=follow'">
        <div class="icon-box" style="background:linear-gradient(135deg, #a1c4fd 0%, #c2e9fb 100%);color:#2980b9;">
            <i class="fa-solid fa-user"></i>
            <?php if($unreads['follow']>0): ?><div class="badge"><?= $unreads['follow'] ?></div><?php endif; ?>
        </div>
        <div class="grid-label">新增关注</div>
    </div>
    <div class="grid-item" onclick="location.href='?box=comment'">
        <div class="icon-box" style="background:linear-gradient(135deg, #84fab0 0%, #8fd3f4 100%);color:#27ae60;">
            <i class="fa-solid fa-comment-dots"></i>
            <?php if($unreads['comment']>0): ?><div class="badge"><?= $unreads['comment'] ?></div><?php endif; ?>
        </div>
        <div class="grid-label">评论和@</div>
    </div>
</div>

<div class="chat-list">
    <div class="list-title">私信列表</div>
    
    <div class="chat-item" onclick="location.href='chat.php?to_id=0'">
        <div class="avt-box">
            <div style="width:48px;height:48px;border-radius:50%;background:#333;display:flex;align-items:center;justify-content:center;color:#fff;font-size:20px;margin-right:12px;">
                <i class="fa-solid fa-earth-asia"></i>
            </div>
        </div>
        <div class="c-info">
            <div class="c-top"><span class="c-name">公共聊天室</span></div>
            <div class="c-msg">点击加入大家的话题</div>
        </div>
        <i class="fa-solid fa-chevron-right" style="color:#eee;font-size:12px;"></i>
    </div>

    <?php foreach($chats as $c): ?>
    <div class="chat-item" onclick="location.href='chat.php?to_id=<?= $c['id'] ?>'">
        <div class="avt-box">
            <img src="<?= $c['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="c-avt">
            <?php if($c['unread']>0): ?><div class="unread-dot"></div><?php endif; ?>
        </div>
        <div class="c-info">
            <div class="c-top">
                <span class="c-name"><?= htmlspecialchars($c['username']) ?></span>
                <span class="c-time"><?= date('m-d', strtotime($c['last_time'])) ?></span>
            </div>
            <div class="c-msg">
                <?php if($c['unread']>0): ?><span style="color:var(--p)">[<?= $c['unread'] ?>条未读]</span><?php endif; ?>
                <?= htmlspecialchars($c['last_msg']) ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>

    <?php if(empty($chats)): ?>
        <div style="text-align:center;padding:30px;color:#ccc;font-size:12px;">暂无私信记录</div>
    <?php endif; ?>
</div>

<nav class="dock">
    <a href="index.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>首页</a>
    <a href="shop.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg>商城</a>
    <div class="dock-item" onclick="location.href='index.php?openPub=1'"><div style="background:#ff2442;border-radius:12px;width:45px;height:32px;display:flex;align-items:center;justify-content:center;"><i class="fa-solid fa-plus" style="color:#fff"></i></div></div>
    <a href="message.php" class="dock-item active"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg>消息</a>
    <a href="user.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg>我</a>
</nav>

</body>
</html>