<?php
require 'db.php';
$token = $_COOKIE['xyb_token'] ?? '';

if(!$token) {
    header("Location: index.php");
    exit;
}

// 1. 拉取最近30条社交动态（点赞、评论、关注）
// 关联 users 表以获取触发者的头像
$sql = "SELECT n.*, u.id as killer_id, u.avatar as killer_avatar 
        FROM notifications n 
        LEFT JOIN users u ON n.from_user = u.username 
        WHERE n.user_token = ? AND n.type != 'chat' 
        ORDER BY n.id DESC LIMIT 30";
$stmt = $conn->prepare($sql);
$stmt->execute([$token]);
$notifs = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 2. 进入页面即全部设为已读
$conn->prepare("UPDATE notifications SET is_read = 1 WHERE user_token = ? AND type != 'chat'")->execute([$token]);
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>消息通知 | 显眼包</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --bg: #050505; --surface: #121212; --primary: #7000ff; --accent: #00ffcc; }
        body { background: var(--bg); color: #fff; font-family: -apple-system, sans-serif; margin: 0; padding-bottom: 20px; }
        
        /* 顶部导航 */
        .header { padding: 15px 20px; background: rgba(17,17,17,0.8); backdrop-filter: blur(10px); position: sticky; top: 0; z-index: 100; border-bottom: 1px solid #222; display: flex; align-items: center; gap: 15px; }
        .header a { color: #fff; text-decoration: none; font-size: 1.2rem; }
        .header h2 { margin: 0; font-size: 1.1rem; flex: 1; }

        /* 列表样式 */
        .notif-list { padding: 10px; }
        .notif-item { display: flex; align-items: center; padding: 15px; border-bottom: 1px solid #1a1a1a; gap: 12px; text-decoration: none; color: inherit; }
        .notif-item:active { background: #111; }
        
        .avatar { width: 45px; height: 45px; border-radius: 50%; object-fit: cover; border: 1px solid #333; flex-shrink: 0; }
        
        .content { flex: 1; overflow: hidden; }
        .title { font-size: 0.95rem; font-weight: bold; margin-bottom: 4px; }
        .title span { font-weight: normal; color: #888; }
        .time { font-size: 0.75rem; color: #444; }

        /* 不同类型的图标 */
        .type-icon { width: 18px; height: 18px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 10px; margin-right: 5px; display: inline-flex; }
        .icon-like { background: #ff0055; color: #fff; }
        .icon-comment { background: var(--primary); color: #fff; }
        .icon-follow { background: var(--accent); color: #000; }

        .empty { text-align: center; padding: 100px 20px; color: #444; }
    </style>
</head>
<body>

    <div class="header">
        <a href="user.php"><i class="fa-solid fa-chevron-left"></i></a>
        <h2>社交动态</h2>
        <div style="width:20px;"></div>
    </div>

    <div class="notif-list">
        <?php if(empty($notifs)): ?>
            <div class="empty">
                <i class="fa-solid fa-bell-slash fa-3x" style="margin-bottom:15px; display:block;"></i>
                目前还没有收到任何互动动态
            </div>
        <?php endif; ?>

        <?php foreach($notifs as $n): 
            $link = ($n['type'] == 'follow') ? "user.php?id=".$n['killer_id'] : "post.php?id=".$n['post_id'];
            $avatar = $n['killer_avatar'] ?: 'https://ui-avatars.com/api/?name='.$n['from_user'];
        ?>
            <a href="<?= $link ?>" class="notif-item">
                <img src="<?= $avatar ?>" class="avatar">
                <div class="content">
                    <div class="title">
                        <?= htmlspecialchars($n['from_user']) ?>
                        <span>
                            <?php if($n['type'] == 'like'): ?>
                                <i class="type-icon icon-like"><i class="fa-solid fa-heart"></i></i>点赞了你的帖子
                            <?php elseif($n['type'] == 'comment'): ?>
                                <i class="type-icon icon-comment"><i class="fa-solid fa-comment"></i></i>评论了你
                            <?php elseif($n['type'] == 'follow'): ?>
                                <i class="type-icon icon-follow"><i class="fa-solid fa-user-plus"></i></i>关注了你
                            <?php endif; ?>
                        </span>
                    </div>
                    <div class="time"><?= date('m-d H:i', strtotime($n['created_at'])) ?></div>
                </div>
                <i class="fa-solid fa-chevron-right" style="color:#222; font-size:0.8rem;"></i>
            </a>
        <?php endforeach; ?>
    </div>

</body>
</html>