<?php
/**
 * notifs.php - 互动通知详情列表
 * 功能：分类展示 赞/粉丝/评论 记录，并标记已读
 */
require 'db.php';

$token = $_COOKIE['xyb_token'] ?? '';
if (!$token) { header("Location: index.php"); exit; }

// 1. 获取当前用户信息
$stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
$stmt->execute([$token]);
$me = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$me) { exit("身份异常"); }
$myId = $me['id'];

// 2. 获取通知类型 (like / follow / comment)
$type = $_GET['type'] ?? 'like';
$titles = [
    'like' => '收到的赞',
    'follow' => '新增粉丝',
    'comment' => '评论和回复',
    'system' => '系统通知'
];
$pageTitle = $titles[$type] ?? '动态通知';

// 3. 将该类型的通知全部标记为已读（消除红点核心逻辑）
$up = $conn->prepare("UPDATE notifications SET is_read = 1 WHERE receiver_id = ? AND type = ?");
$up->execute([$myId, $type]);

// 4. 拉取通知列表（关联发送者信息）
$sql = "SELECT n.*, u.username as sender_name, u.avatar as sender_avatar, u.id as sender_id
        FROM notifications n
        LEFT JOIN users u ON n.sender_id = u.id
        WHERE n.receiver_id = ? AND n.type = ?
        ORDER BY n.id DESC LIMIT 50";
$stmt_list = $conn->prepare($sql);
$stmt_list->execute([$myId, $type]);
$list = $stmt_list->fetchAll(PDO::FETCH_ASSOC);

$siteName = get_setting('site_name', 'XYB.APP');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?= $pageTitle ?> - <?= htmlspecialchars($siteName) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --bg: #050505; --surface: #121212; --primary: #7000ff; --accent: #00ffcc; --text-main: #fff; --text-sub: #888; }
        body { background: var(--bg); color: var(--text-main); font-family: -apple-system, sans-serif; margin: 0; }
        
        .header { padding: 15px; border-bottom: 1px solid #222; display: flex; align-items: center; background: rgba(5,5,5,0.9); backdrop-filter: blur(10px); position: sticky; top: 0; z-index: 100; }
        .back-btn { font-size: 20px; color: #fff; text-decoration: none; margin-right: 15px; }
        .page-title { font-size: 17px; font-weight: bold; flex: 1; text-align: center; margin-right: 35px; }

        .list-container { padding: 10px 0; }
        .notif-item { display: flex; align-items: center; padding: 15px; border-bottom: 1px solid #1a1a1a; text-decoration: none; color: inherit; transition: 0.2s; }
        .notif-item:active { background: #111; }
        
        .avatar { width: 48px; height: 48px; border-radius: 50%; object-fit: cover; margin-right: 12px; border: 1px solid #222; }
        
        .content-box { flex: 1; min-width: 0; }
        .user-name { font-weight: bold; font-size: 14px; margin-bottom: 4px; color: #eee; }
        .action-text { font-size: 14px; color: #aaa; }
        .time { font-size: 11px; color: #555; margin-top: 5px; }

        .post-preview { width: 50px; height: 50px; border-radius: 6px; background: #222; object-fit: cover; margin-left: 10px; }
        
        .empty-state { text-align: center; padding: 100px 0; color: #444; }
        .empty-state i { font-size: 50px; margin-bottom: 10px; }
    </style>
</head>
<body>

<div class="header">
    <a href="message.php" class="back-btn"><i class="fa-solid fa-chevron-left"></i></a>
    <div class="page-title"><?= $pageTitle ?></div>
</div>

<div class="list-container">
    <?php foreach($list as $item): ?>
    <a href="<?= $item['type'] == 'follow' ? 'user.php?id='.$item['sender_id'] : 'post.php?id='.$item['post_id'] ?>" class="notif-item">
        <img src="<?= $item['sender_avatar'] ?: 'https://ui-avatars.com/api/?name='.$item['sender_name'] ?>" class="avatar">
        
        <div class="content-box">
            <div class="user-name"><?= htmlspecialchars($item['sender_name']) ?></div>
            <div class="action-text">
                <?php 
                switch($item['type']) {
                    case 'like': echo "点赞了你的动态"; break;
                    case 'follow': echo "开始关注你了"; break;
                    case 'comment': echo "评论了你：".htmlspecialchars(mb_substr($item['content'], 0, 20)); break;
                    case 'system': echo htmlspecialchars($item['content']); break;
                }
                ?>
            </div>
            <div class="time"><?= date('Y-m-d H:i', strtotime($item['created_at'])) ?></div>
        </div>

        <?php if($item['post_id'] > 0 && ($item['type'] == 'like' || $item['type'] == 'comment')): ?>
            <?php 
                $p_stmt = $conn->prepare("SELECT image_url FROM posts WHERE id = ?");
                $p_stmt->execute([$item['post_id']]);
                $p_img = $p_stmt->fetchColumn();
                // 如果是 JSON 数组，取第一张
                $img_data = json_decode($p_img, true);
                $img_src = is_array($img_data) ? $img_data[0] : $p_img;
                if($img_src):
            ?>
                <img src="<?= htmlspecialchars($img_src) ?>" class="post-preview">
            <?php endif; ?>
        <?php endif; ?>
    </a>
    <?php endforeach; ?>

    <?php if(empty($list)): ?>
    <div class="empty-state">
        <i class="fa-regular fa-bell-slash"></i>
        <p>暂无相关提醒</p>
    </div>
    <?php endif; ?>
</div>

</body>
</html>