<?php
/**
 * post.php - v23.0 完美交互版
 * 1. 修复评论框交互：底部固定，点击弹窗输入
 * 2. 修复关注状态：PHP端增加查询，JS端增加即时反馈
 * 3. 视觉优化：保持与首页一致的清爽风格
 */
require 'db.php';

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) die("帖子不存在");

$token = $_COOKIE['xyb_token'] ?? '';
$currentUser = null;
if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $currentUser = $stmt->fetch(PDO::FETCH_ASSOC);
}

// --- 1. 处理评论提交 ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'comment') {
    header('Content-Type: application/json');
    if (!$currentUser) { echo json_encode(['status'=>'error', 'msg'=>'请先登录']); exit; }
    
    $content = trim($_POST['content']);
    $parentId = intval($_POST['parent_id'] ?? 0);
    
    if (!$content) { echo json_encode(['status'=>'error', 'msg'=>'内容不能为空']); exit; }
    
    try {
        $stmt = $conn->prepare("INSERT INTO comments (post_id, user_id, parent_id, content, username) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$id, $currentUser['id'], $parentId, $content, $currentUser['username']]);
        
        $postOwner = $conn->query("SELECT user_id FROM posts WHERE id=$id")->fetchColumn();
        if ($postOwner && $postOwner != $currentUser['id']) {
            $conn->prepare("INSERT INTO notifications (receiver_id, sender_id, type, post_id, content) VALUES (?, ?, 'comment', ?, ?)")
                 ->execute([$postOwner, $currentUser['id'], $id, $content]);
        }
        echo json_encode(['status'=>'success']);
    } catch (Exception $e) { echo json_encode(['status'=>'error', 'msg'=>'评论失败']); }
    exit;
}

// --- 2. 处理点赞 ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'like') {
    header('Content-Type: application/json');
    if (!$currentUser) { echo json_encode(['status'=>'error', 'msg'=>'请先登录']); exit; }
    try {
        $check = $conn->query("SELECT id FROM post_likes WHERE user_id={$currentUser['id']} AND post_id=$id")->fetch();
        if ($check) {
            $conn->exec("DELETE FROM post_likes WHERE user_id={$currentUser['id']} AND post_id=$id");
            $conn->exec("UPDATE posts SET likes = likes - 1 WHERE id=$id");
            echo json_encode(['status'=>'success', 'is_liked'=>false]);
        } else {
            $conn->exec("INSERT INTO post_likes (user_id, post_id) VALUES ({$currentUser['id']}, $id)");
            $conn->exec("UPDATE posts SET likes = likes + 1 WHERE id=$id");
            echo json_encode(['status'=>'success', 'is_liked'=>true]);
        }
    } catch (Exception $e) { echo json_encode(['status'=>'error']); }
    exit;
}

// --- 3. 获取数据 ---
$stmt = $conn->prepare("SELECT p.*, u.username, u.avatar, u.city as author_city FROM posts p LEFT JOIN users u ON p.user_id = u.id WHERE p.id = ?");
$stmt->execute([$id]);
$post = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$post) die("内容已被删除");

// 获取评论
$stmt_c = $conn->prepare("SELECT c.*, u.username, u.avatar, u.city,
    (SELECT value FROM user_assets ua LEFT JOIN assets a ON ua.asset_id=a.id WHERE ua.user_id=u.id AND ua.is_equipped=1 AND a.type='title' LIMIT 1) as title_text,
    (SELECT style FROM user_assets ua LEFT JOIN assets a ON ua.asset_id=a.id WHERE ua.user_id=u.id AND ua.is_equipped=1 AND a.type='title' LIMIT 1) as title_style
    FROM comments c LEFT JOIN users u ON c.user_id = u.id WHERE c.post_id = ? ORDER BY c.id ASC");
$stmt_c->execute([$id]);
$raw_comments = $stmt_c->fetchAll(PDO::FETCH_ASSOC);

$comments_tree = [];
$comments_map = [];
foreach ($raw_comments as $c) { $c['children'] = []; $comments_map[$c['id']] = $c; }
foreach ($raw_comments as $c) {
    if ($c['parent_id'] > 0 && isset($comments_map[$c['parent_id']])) {
        $comments_map[$c['parent_id']]['children'][] = $c;
    } else {
        $comments_tree[] = &$comments_map[$c['id']];
    }
}

$imgs = json_decode(stripslashes($post['image_url'] ?? ''), true);
if (!is_array($imgs)) $imgs = (!empty($post['image_url']) && $post['image_url']!='null') ? [$post['image_url']] : [];

// 🔥 修复：正确查询当前用户是否点赞和关注
$isLiked = false;
$isFollowing = false;
if ($currentUser) {
    // 查点赞
    $checkLike = $conn->query("SELECT id FROM post_likes WHERE user_id={$currentUser['id']} AND post_id=$id")->fetch();
    if ($checkLike) $isLiked = true;
    
    // 查关注
    $checkFollow = $conn->query("SELECT id FROM follows WHERE follower_id={$currentUser['id']} AND following_id={$post['user_id']}")->fetch();
    if ($checkFollow) $isFollowing = true;
}

$siteName = get_setting('site_name', 'Slice');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>详情 - <?= htmlspecialchars($siteName) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <style>
        :root { --bg: #fff; --p: #ff2442; --gray: #f5f5f5; }
        * { box-sizing: border-box; outline: none; -webkit-tap-highlight-color: transparent; }
        body { margin: 0; background: var(--bg); font-family: -apple-system, sans-serif; padding-bottom: 80px; }
        
        .page-wrapper { display: flex; justify-content: center; min-height: 100vh; }
        @media (min-width: 850px) {
            body { background: #f2f4f6; padding-bottom: 0; }
            .page-wrapper { padding-top: 40px; padding-bottom: 40px; }
        }

        .pc-back-btn { position: fixed; left: 40px; top: 40px; width: 50px; height: 50px; background: #fff; border-radius: 50%; box-shadow: 0 4px 15px rgba(0,0,0,0.1); display: none; align-items: center; justify-content: center; cursor: pointer; color: #333; font-size: 20px; transition: 0.3s; z-index: 200; }
        .pc-back-btn:hover { transform: translateX(-5px); color: var(--p); }
        @media (min-width: 850px) { .pc-back-btn { display: flex; } }

        .main-card { width: 100%; max-width: 600px; background: #fff; position: relative; }
        @media (min-width: 850px) {
            .main-card { border-radius: 24px; box-shadow: 0 10px 40px rgba(0,0,0,0.08); height: calc(100vh - 80px); overflow: hidden; display: flex; flex-direction: column; }
        }

        .navbar { display: flex; align-items: center; justify-content: space-between; padding: 10px 15px; border-bottom: 1px solid #eee; background: #fff; position: sticky; top: 0; z-index: 90; }
        @media (min-width: 850px) { .navbar { display: none; } }

        .scroll-container { flex: 1; overflow-y: auto; padding-bottom: 20px; }
        .scroll-container::-webkit-scrollbar { width: 6px; }
        .scroll-container::-webkit-scrollbar-thumb { background: #ddd; border-radius: 3px; }

        .u-info-row { padding: 20px; display: flex; align-items: center; justify-content: space-between; }
        .u-box { display: flex; align-items: center; gap: 12px; cursor: pointer; }
        .u-avatar { width: 44px; height: 44px; border-radius: 50%; border: 1px solid #eee; object-fit: cover; }
        .u-name { font-weight: bold; font-size: 16px; color: #333; }
        .time { font-size: 12px; color: #999; margin-top: 2px; }
        
        .btn-follow { 
            border: 1px solid var(--p); color: var(--p); 
            padding: 6px 20px; border-radius: 20px; background: #fff; 
            font-size: 13px; font-weight: bold; cursor: pointer; transition: 0.2s; 
        }
        .btn-follow:hover { background: #fff5f5; }
        /* 已关注样式 */
        .btn-follow.followed { 
            background: #eee; border-color: #ddd; color: #999; 
        }

        .swiper { width: 100%; aspect-ratio: 1/1; background: #f9f9f9; }
        .swiper-slide { display: flex; align-items: center; justify-content: center; }
        .swiper-slide img { width: 100%; height: 100%; object-fit: contain; }

        .post-text { padding: 20px; font-size: 17px; line-height: 1.7; color: #333; white-space: pre-wrap; }
        .post-footer-info { padding: 0 20px 20px; font-size: 12px; color: #ccc; }

        .comment-area { padding: 0 20px; border-top: 1px solid #f5f5f5; padding-top: 25px; }
        .cmt-title { font-size: 15px; font-weight: bold; margin-bottom: 20px; color: #333; }
        
        .cmt-item { display: flex; gap: 12px; margin-bottom: 25px; }
        .c-avatar { width: 34px; height: 34px; border-radius: 50%; cursor: pointer; flex-shrink: 0; object-fit: cover; }
        .c-body { flex: 1; }
        .c-user { font-size: 13px; color: #666; font-weight: bold; margin-bottom: 6px; display: flex; align-items: center; gap: 5px; }
        .title-badge { font-size: 10px; padding: 1px 4px; border-radius: 4px; font-weight: bold; }
        .c-content { font-size: 15px; line-height: 1.5; color: #333; cursor: pointer; }
        .c-meta { margin-top: 8px; font-size: 12px; color: #aaa; display: flex; gap: 15px; align-items: center; }
        .reply-btn { cursor: pointer; font-weight: 600; color: #666; }
        .ip-tag { color: #ccc; }

        .sub-box { background: #f8f8f8; padding: 12px; border-radius: 12px; margin-top: 10px; font-size: 14px; }
        .sub-row { margin-bottom: 8px; line-height: 1.5; cursor: pointer; }
        
        /* 🔥 底部栏优化：点击不变形 */
        .footer-bar { 
            background: #fff; border-top: 1px solid #f5f5f5; padding: 10px 15px; 
            display: flex; align-items: center; gap: 12px; z-index: 100; height: 60px;
        }
        @media (max-width: 849px) {
            .footer-bar { position: fixed; bottom: 0; left: 0; width: 100%; padding-bottom: calc(10px + env(safe-area-inset-bottom)); }
        }

        .inp-wrap { 
            flex: 1; background: #f5f5f5; border-radius: 24px; height: 40px; 
            padding: 0 15px; display: flex; align-items: center; cursor: text; 
            color: #999; font-size: 14px;
        }
        
        .action-icon { font-size: 24px; color: #333; cursor: pointer; margin-left: 5px; display: flex; align-items: center; gap: 4px; }
        .action-icon.liked { color: var(--p); }
        .action-icon span { font-size: 14px; font-weight: bold; }

        /* 🔥 评论弹窗优化 */
        .modal-overlay { display:none; position:fixed; inset:0; background:rgba(0,0,0,0.5); z-index:999; align-items:flex-end; }
        .cmt-modal { 
            background:#fff; width:100%; border-radius:16px 16px 0 0; padding:15px; 
            animation: slideUp 0.3s; padding-bottom: calc(15px + env(safe-area-inset-bottom));
        }
        .cmt-header { display:flex; justify-content:space-between; margin-bottom:10px; font-size:14px; color:#666; }
        .cmt-real-inp { 
            width:100%; height:100px; border:none; resize:none; font-size:16px; outline:none; 
            background:#f5f5f5; padding:12px; border-radius:12px; margin-bottom:10px; font-family:inherit;
        }
        .cmt-sub-btn { 
            background:var(--p); color:#fff; border:none; padding:8px 24px; 
            border-radius:20px; font-weight:bold; float:right; cursor:pointer; font-size:14px;
        }
        @keyframes slideUp { from { transform:translateY(100%); } to { transform:translateY(0); } }
    </style>
</head>
<body>

<div class="pc-back-btn" onclick="location.href='index.php'" title="返回首页">
    <i class="fa-solid fa-arrow-left"></i>
</div>

<div class="page-wrapper">
    <div class="main-card">
        
        <div class="navbar">
            <i class="fa-solid fa-chevron-left" onclick="history.back()" style="font-size:20px;cursor:pointer;"></i>
            <div class="u-info" onclick="location.href='user.php?id=<?= $post['user_id'] ?>'" style="display:flex;align-items:center;gap:8px;">
                <img src="<?= $post['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="avatar" style="width:30px;height:30px;border-radius:50%;object-fit:cover;">
                <span style="font-weight:bold;font-size:14px;"><?= htmlspecialchars($post['is_anonymous']?'某同学':$post['username']) ?></span>
            </div>
            <i class="fa-solid fa-ellipsis" style="opacity:0;"></i>
        </div>

        <div class="scroll-container">
            <div class="u-info-row">
                <div class="u-box" onclick="location.href='user.php?id=<?= $post['user_id'] ?>'">
                    <img src="<?= $post['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="u-avatar">
                    <div>
                        <div class="u-name"><?= htmlspecialchars($post['is_anonymous']?'某同学':$post['username']) ?></div>
                        <div class="time"><?= date('m-d H:i', strtotime($post['created_at'])) ?></div>
                    </div>
                </div>
                <?php if(!$currentUser || $currentUser['id'] != $post['user_id']): ?>
                <button class="btn-follow <?= $isFollowing?'followed':'' ?>" id="followBtn" onclick="toggleFollow(<?= $post['user_id'] ?>)">
                    <?= $isFollowing?'已关注':'关注' ?>
                </button>
                <?php endif; ?>
            </div>

            <?php if($imgs): ?>
            <div class="swiper mySwiper">
                <div class="swiper-wrapper">
                    <?php foreach($imgs as $img): ?><div class="swiper-slide"><img src="<?= htmlspecialchars($img) ?>"></div><?php endforeach; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
            <?php endif; ?>

            <div class="post-text"><?= htmlspecialchars($post['content']) ?></div>
            <div class="post-footer-info">
                <?php if($post['author_city']): ?>发布于 <?= htmlspecialchars($post['author_city']) ?><?php endif; ?>
            </div>

            <div class="comment-area">
                <div class="cmt-title">共 <?= count($raw_comments) ?> 条评论</div>
                
                <?php foreach($comments_tree as $root): ?>
                <div class="cmt-item">
                    <img src="<?= $root['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="c-avatar" onclick="location.href='user.php?id=<?=$root['user_id']?>'">
                    <div class="c-body">
                        <div class="c-user">
                            <?= htmlspecialchars($root['username']) ?>
                            <?php if(!empty($root['title_text'])): ?>
                                <span class="title-badge" style="<?= $root['title_style'] ?>"><?= $root['title_text'] ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="c-content" onclick="reply(<?= $root['id'] ?>, '<?= $root['username'] ?>')">
                            <?= htmlspecialchars($root['content']) ?>
                        </div>
                        <div class="c-meta">
                            <span><?= date('m-d', strtotime($root['created_at'])) ?></span>
                            <span class="ip-tag">IP: <?= htmlspecialchars($root['city'] ?: '未知') ?></span>
                            <span class="reply-btn" onclick="reply(<?= $root['id'] ?>, '<?= $root['username'] ?>')">回复</span>
                        </div>

                        <?php if(!empty($root['children'])): ?>
                        <div class="sub-box">
                            <?php foreach($root['children'] as $child): ?>
                            <div class="sub-row" onclick="reply(<?= $root['id'] ?>, '<?= $child['username'] ?>')">
                                <b><?= htmlspecialchars($child['username']) ?></b> 
                                <?php if($child['username'] != $root['username']): ?>
                                    <span style="color:#999">回复</span> <b><?= htmlspecialchars($root['username']) ?></b>
                                <?php endif; ?>
                                : <?= htmlspecialchars($child['content']) ?>
                                <span style="font-size:10px;color:#ccc;margin-left:5px;">IP: <?= htmlspecialchars($child['city'] ?: '未知') ?></span>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
                <div style="height:30px;"></div>
            </div>
        </div>

        <div class="footer-bar">
            <div class="inp-wrap" onclick="openCmt()">
                <i class="fa-regular fa-face-smile" style="margin-right:8px;font-size:20px;color:#666;"></i>
                说点什么...
            </div>
            <div class="action-icon <?= $isLiked?'liked':'' ?>" onclick="doLike(this)">
                <i class="fa-<?= $isLiked?'solid':'regular' ?> fa-heart"></i>
                <span id="likeCount"><?= $post['likes'] ?></span>
            </div>
            <div class="action-icon" onclick="openCmt()">
                <i class="fa-regular fa-comment-dots"></i>
                <span><?= count($raw_comments) ?></span>
            </div>
        </div>
    </div>
</div>

<div class="modal-overlay" id="cmtModal" onclick="if(event.target===this) this.style.display='none'">
    <div class="cmt-modal">
        <div class="cmt-header">
            <span onclick="document.getElementById('cmtModal').style.display='none'">取消</span>
            <span style="font-weight:bold;color:#333;">发表评论</span>
        </div>
        <textarea id="cmtContent" class="cmt-real-inp" placeholder="友善评论，温暖人心..."></textarea>
        <div style="overflow:hidden;">
            <button class="cmt-sub-btn" onclick="sendCmt()">发送</button>
        </div>
    </div>
</div>

<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
<script>
    var swiper = new Swiper(".mySwiper", { pagination: { el: ".swiper-pagination" } });

    let pid = 0;
    
    function openCmt() {
        <?php if(!$currentUser): ?>
            if(confirm('登录后才能评论，去登录？')) location.href='login.php';
            return;
        <?php endif; ?>
        document.getElementById('cmtModal').style.display = 'flex';
        setTimeout(() => document.getElementById('cmtContent').focus(), 100);
    }

    function reply(id, name) {
        pid = id;
        openCmt();
        const inp = document.getElementById('cmtContent');
        inp.placeholder = '回复 @' + name;
    }

    function sendCmt() {
        const txt = document.getElementById('cmtContent').value.trim();
        if(!txt) return alert('写点什么吧');
        
        const btn = document.querySelector('.cmt-sub-btn');
        btn.innerText = '...'; btn.disabled = true;

        const fd = new FormData();
        fd.append('action', 'comment');
        fd.append('content', txt);
        fd.append('parent_id', pid);
        
        fetch('', {method:'POST', body:fd}).then(r=>r.json()).then(res=>{
            if(res.status==='success') location.reload();
            else { alert(res.msg); btn.innerText='发送'; btn.disabled=false; }
        });
    }

    function doLike(el) {
        <?php if(!$currentUser): ?>
            if(confirm('登录后才能点赞，去登录？')) location.href='login.php';
            return;
        <?php endif; ?>

        const fd = new FormData(); fd.append('action','like');
        fetch('', {method:'POST', body:fd}).then(r=>r.json()).then(res=>{
            if(res.status==='success') {
                const icon = el.querySelector('i');
                const num = el.querySelector('span');
                let n = parseInt(num.innerText);
                if(res.is_liked) {
                    el.classList.add('liked');
                    icon.classList.replace('fa-regular', 'fa-solid');
                    num.innerText = n + 1;
                } else {
                    el.classList.remove('liked');
                    icon.classList.replace('fa-solid', 'fa-regular');
                    num.innerText = n - 1;
                }
            }
        });
    }

    // 🔥 修复：关注按钮即时更新
    function toggleFollow(uid) {
        <?php if(!$currentUser): ?>
            if(confirm('登录后才能关注，去登录？')) location.href='login.php';
            return;
        <?php endif; ?>
        
        const btn = document.getElementById('followBtn');
        const fd = new FormData(); fd.append('action','follow'); fd.append('id', uid);
        
        fetch('api.php', {method:'POST', body:fd}).then(r=>r.json()).then(res=>{
            if(res.status==='success') { 
                if(res.type === 'followed') {
                    btn.classList.add('followed');
                    btn.innerText = '已关注';
                } else {
                    btn.classList.remove('followed');
                    btn.innerText = '关注';
                }
            } 
            else alert(res.msg);
        });
    }
</script>
</body>
</html>