<?php
/**
 * product.php - v19.1 沉浸式海报版 (修复分享功能)
 */
require 'db.php';

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) die("商品不存在");

$sql = "SELECT p.*, u.username, u.avatar, u.last_active, u.id as seller_uid FROM products p LEFT JOIN users u ON p.user_id = u.id WHERE p.id = ?";
$stmt = $conn->prepare($sql);
$stmt->execute([$id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$product) die("商品已下架或删除");

$token = $_COOKIE['xyb_token'] ?? '';
$myId = 0;
if ($token) {
    $u = $conn->prepare("SELECT id FROM users WHERE token = ?");
    $u->execute([$token]);
    $me = $u->fetch();
    $myId = $me['id'] ?? 0;
}
$isOwner = ($myId == $product['seller_uid']);
$siteName = get_setting('site_name', 'Slice');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title><?= htmlspecialchars($product['title']) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --p: #ff2442; --bg: #f4f4f4; --card: #fff; --text: #111; --price: #ff4400; }
        * { box-sizing: border-box; outline: none; -webkit-tap-highlight-color: transparent; }
        body { margin: 0; background: var(--bg); font-family: -apple-system, sans-serif; color: var(--text); padding-bottom: 90px; }

        .nav-bar { position: fixed; top: 0; left: 0; width: 100%; z-index: 100; padding: 15px 20px; display: flex; justify-content: space-between; background: linear-gradient(180deg, rgba(0,0,0,0.4) 0%, rgba(0,0,0,0) 100%); pointer-events: none; }
        .nav-icon { width: 36px; height: 36px; background: rgba(255,255,255,0.2); backdrop-filter: blur(5px); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #fff; font-size: 18px; cursor: pointer; border: 1px solid rgba(255,255,255,0.3); pointer-events: auto; }

        .hero-img-box { width: 100%; height: 400px; background: #eee; position: relative; }
        .hero-img { width: 100%; height: 100%; object-fit: cover; }
        .hero-text-cover { width:100%; height:100%; display:flex; align-items:center; justify-content:center; padding:40px; font-size:24px; font-weight:900; color:#fff; text-align:center; background:linear-gradient(135deg, #a18cd1 0%, #fbc2eb 100%); }
        .sold-layer { position: absolute; inset: 0; background: rgba(0,0,0,0.5); display: flex; align-items: center; justify-content: center; color: #fff; font-size: 24px; font-weight: bold; letter-spacing: 2px; backdrop-filter: blur(3px); }

        .main-card { background: #fff; border-radius: 20px 20px 0 0; margin-top: -20px; position: relative; z-index: 10; padding: 25px 20px; box-shadow: 0 -5px 20px rgba(0,0,0,0.02); }
        .price-row { display: flex; align-items: baseline; color: var(--price); font-weight: 900; margin-bottom: 12px; }
        .currency { font-size: 18px; margin-right: 2px; }
        .amount { font-size: 32px; letter-spacing: -1px; }
        .tag-new { margin-left: 10px; background: #ffeee5; color: #ff4400; font-size: 11px; padding: 2px 6px; border-radius: 4px; font-weight: bold; vertical-align: text-top; }
        
        .p-title { font-size: 20px; font-weight: 900; line-height: 1.4; color: #000; margin-bottom: 15px; }
        .p-desc { font-size: 16px; line-height: 1.7; color: #444; white-space: pre-wrap; }
        .meta-row { display: flex; justify-content: space-between; font-size: 12px; color: #999; margin-top: 20px; padding-top: 15px; border-top: 1px solid #f9f9f9; }

        .seller-card { margin: 10px 0; background: #fff; padding: 15px 20px; display: flex; align-items: center; justify-content: space-between; }
        .seller-left { display: flex; align-items: center; gap: 12px; }
        .s-avatar { width: 44px; height: 44px; border-radius: 50%; border: 1px solid #eee; }
        .s-info { display: flex; flex-direction: column; }
        .s-name { font-weight: bold; font-size: 15px; color: #000; }
        .s-tag { font-size: 10px; color: #00b894; background: #e0fbf4; padding: 1px 5px; border-radius: 4px; margin-top: 2px; display: inline-block; }
        .s-arrow { color: #ccc; font-size: 14px; }

        .safe-tip { margin: 10px 20px; background: #f9f9f9; padding: 12px; border-radius: 8px; font-size: 12px; color: #999; display: flex; gap: 8px; line-height: 1.4; }

        .bottom-dock { position: fixed; bottom: 0; left: 0; width: 100%; background: #fff; border-top: 1px solid #eee; padding: 10px 15px; padding-bottom: calc(10px + env(safe-area-inset-bottom)); display: flex; align-items: center; gap: 15px; z-index: 90; }
        .action-group { display: flex; gap: 20px; margin-right: auto; padding-left: 5px; }
        .icon-btn { display: flex; flex-direction: column; align-items: center; color: #333; font-size: 10px; gap: 3px; cursor: pointer; }
        .icon-btn i { font-size: 20px; }
        .buy-group { display: flex; gap: 10px; }
        .btn-buy { background: #ffda44; color: #000; font-weight: bold; padding: 10px 25px; border-radius: 25px; border: none; font-size: 15px; cursor: pointer; box-shadow: 0 4px 10px rgba(255, 218, 68, 0.3); }
        .btn-want { background: #111; color: #fff; font-weight: bold; padding: 10px 25px; border-radius: 25px; border: none; font-size: 15px; cursor: pointer; box-shadow: 0 4px 10px rgba(0,0,0,0.3); }
        .btn-disabled { background: #eee; color: #999; cursor: not-allowed; box-shadow: none; width: 100px; }

        .share-modal { display:none; position:fixed; inset:0; background:rgba(0,0,0,0.5); z-index:200; align-items:flex-end; }
        .share-panel { background:#fff; width:100%; padding:25px; border-radius:20px 20px 0 0; animation:slideUp 0.3s; }
        @keyframes slideUp { from{transform:translateY(100%)} to{transform:translateY(0)} }
    </style>
</head>
<body>

<div class="nav-bar">
    <div class="nav-icon" onclick="history.back()"><i class="fa-solid fa-arrow-left"></i></div>
    <div class="nav-icon" onclick="openShare()"><i class="fa-solid fa-share"></i></div>
</div>

<div class="hero-img-box">
    <?php if($product['image_url']): ?>
        <img src="<?= htmlspecialchars($product['image_url']) ?>" class="hero-img">
    <?php else: ?>
        <div class="hero-text-cover"><?= htmlspecialchars($product['title']) ?></div>
    <?php endif; ?>
    
    <?php if($product['status'] == 0): ?>
        <div class="sold-layer">SOLD OUT</div>
    <?php endif; ?>
</div>

<div class="main-card">
    <div class="price-row">
        <span class="currency">¥</span>
        <span class="amount"><?= floatval($product['price']) ?></span>
        <span class="tag-new">全新闲置</span>
    </div>
    <div class="p-title"><?= htmlspecialchars($product['title']) ?></div>
    <div class="p-desc"><?= nl2br(htmlspecialchars($product['description'])) ?></div>
    <div class="meta-row">
        <span><i class="fa-regular fa-eye"></i> <?= rand(100, 999) ?> 浏览</span>
        <span>发布于 <?= date('Y-m-d', strtotime($product['created_at'])) ?></span>
    </div>
</div>

<div class="seller-card" onclick="location.href='user.php?id=<?= $product['seller_uid'] ?>'">
    <div class="seller-left">
        <img src="<?= $product['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="s-avatar">
        <div class="s-info">
            <div class="s-name"><?= htmlspecialchars($product['username']) ?></div>
            <div><span class="s-tag">信用极好</span> <span style="font-size:10px;color:#999">最近活跃</span></div>
        </div>
    </div>
    <i class="fa-solid fa-chevron-right s-arrow"></i>
</div>

<div class="safe-tip">
    <i class="fa-solid fa-shield-halved" style="color:#00b894;margin-top:2px;"></i>
    <div>交易前请先聊一聊，不支持站外交易。如遇诈骗请立即举报。</div>
</div>

<div class="bottom-dock">
    <?php if($isOwner): ?>
        <div class="action-group">
            <div class="icon-btn" onclick="alert('擦亮成功')"><i class="fa-solid fa-bolt"></i> 擦亮</div>
            <div class="icon-btn" onclick="location.href='shop.php'"><i class="fa-solid fa-store"></i> 更多</div>
        </div>
        <div class="buy-group">
            <?php if($product['status']==1): ?>
                <button class="btn-buy" style="background:#eee;color:#333" onclick="setStatus(0)">标记已出</button>
                <button class="btn-want" style="background:#ff2442" onclick="delProduct()">删除商品</button>
            <?php else: ?>
                <button class="btn-buy" onclick="setStatus(1)">重新上架</button>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="action-group">
            <div class="icon-btn" onclick="toggleLike(this)"><i class="fa-regular fa-heart"></i> 想要</div>
            <div class="icon-btn" onclick="openShare()"><i class="fa-solid fa-share-nodes"></i> 分享</div>
            <div class="icon-btn" onclick="location.href='user.php?id=<?= $product['seller_uid'] ?>'"><i class="fa-solid fa-store"></i> 进店</div>
        </div>
        <div class="buy-group">
            <?php if($product['status']==1): ?>
                <button class="btn-buy" onclick="location.href='chat.php?to_id=<?= $product['seller_uid'] ?>'">聊一聊</button>
                <button class="btn-want" onclick="alert('请联系卖家私聊交易')">我想要</button>
            <?php else: ?>
                <button class="btn-buy btn-disabled">卖掉了</button>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<div class="share-modal" id="shareModal" onclick="if(event.target===this) this.style.display='none'">
    <div class="share-panel">
        <h3 style="margin:0 0 20px 0;text-align:center;">分享给朋友</h3>
        <div style="display:flex;gap:20px;overflow-x:auto;padding-bottom:10px;" id="shareList">
            <div style="color:#999;width:100%;text-align:center;">加载好友中...</div>
        </div>
        <div style="margin-top:20px;padding:15px;background:#f5f5f5;text-align:center;border-radius:10px;font-weight:bold;cursor:pointer;" onclick="document.getElementById('shareModal').style.display='none'">取消</div>
    </div>
</div>

<script>
    <?php if($isOwner): ?>
    function setStatus(s) {
        if(!confirm(s==0?'确定标记为已卖出？':'确定重新上架？')) return;
        const fd = new FormData(); fd.append('action', 'update_product_status'); fd.append('id', <?= $id ?>); fd.append('status', s);
        fetch('submit_product.php', { method:'POST', body:fd }).then(r=>r.json()).then(res=>{ if(res.status==='success') location.reload(); });
    }
    function delProduct() {
        if(!confirm('确定删除？无法恢复。')) return;
        const fd = new FormData(); fd.append('action', 'delete_product'); fd.append('id', <?= $id ?>);
        fetch('submit_product.php', { method:'POST', body:fd }).then(r=>r.json()).then(res=>{ if(res.status==='success') location.href='shop.php'; });
    }
    <?php endif; ?>

    function openShare() {
        document.getElementById('shareModal').style.display = 'flex';
        // 🔥 修复：使用与 chat.php 相同的逻辑获取联系人
        fetch('api.php?action=get_contacts').then(r=>r.json()).then(res => {
            if(res.status === 'success' && res.data.length > 0) {
                let html = '';
                res.data.forEach(u => {
                    html += `
                    <div style="text-align:center;width:60px;flex-shrink:0;cursor:pointer;" onclick="doShare(${u.id}, '${u.username}')">
                        <img src="${u.avatar}" style="width:50px;height:50px;border-radius:50%;margin-bottom:5px;">
                        <div style="font-size:12px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;">${u.username}</div>
                    </div>`;
                });
                document.getElementById('shareList').innerHTML = html;
            } else {
                document.getElementById('shareList').innerHTML = '<div style="color:#999;text-align:center;width:100%;">暂无最近联系人<br>快去聊天吧</div>';
            }
        });
    }

    function doShare(uid, name) {
        if(!confirm('发送给 ' + name + '?')) return;
        const fd = new FormData();
        fd.append('action', 'send_chat'); fd.append('to_id', uid); 
        fd.append('type', 'product'); fd.append('ref_id', <?= $id ?>);
        // 为了兼容旧版 chat，保留一个文本说明
        fd.append('msg', '[分享商品]'); 
        
        fetch('api.php', {method:'POST', body:fd}).then(r=>r.json()).then(res=>{
            if(res.status==='success') { alert('已发送'); document.getElementById('shareModal').style.display='none'; }
        });
    }
    
    function toggleLike(btn) {
        const i = btn.querySelector('i');
        if(i.classList.contains('fa-regular')) {
            i.classList.remove('fa-regular'); i.classList.add('fa-solid'); i.style.color = '#ff2442';
        } else {
            i.classList.add('fa-regular'); i.classList.remove('fa-solid'); i.style.color = '#333';
        }
    }
</script>
</body>
</html>