<?php
/**
 * rank.php - v4.0 风格统一修复版
 * 特性：去除链接下划线、回归简约PC侧边栏、纯净榜单布局
 */
require 'db.php';

// 获取高赞动态
$sql = "SELECT p.*, u.username, u.avatar FROM posts p LEFT JOIN users u ON p.user_id = u.id ORDER BY p.likes DESC LIMIT 50";
$posts = $conn->query($sql)->fetchAll(PDO::FETCH_ASSOC);

// 未读消息
$token = $_COOKIE['xyb_token'] ?? '';
$unread_total = 0;
if($token) {
    try {
        $stmt = $conn->prepare("SELECT id FROM users WHERE token=?"); $stmt->execute([$token]); 
        $me=$stmt->fetch();
        if($me) {
            $uid = $me['id'];
            $unread_total = (int)$conn->query("SELECT (SELECT COUNT(*) FROM notifications WHERE receiver_id=$uid AND is_read=0) + (SELECT COUNT(*) FROM chat WHERE to_user_id=$uid AND is_read=0)")->fetchColumn();
        }
    } catch(Exception $e){}
}
$siteName = get_setting('site_name', 'Slice');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>热门榜单 - <?= htmlspecialchars($siteName) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --bg: #f8f8f8; --card: #fff; --text: #333; --gold: #FFD700; --silver: #C0C0C0; --bronze: #CD7F32; --red: #ff2442; --sidebar-w: 240px; }
        * { margin: 0; padding: 0; box-sizing: border-box; outline: none; -webkit-tap-highlight-color: transparent; }
        
        /* 🔥 核心修复：强制去除所有链接下划线 */
        a { text-decoration: none !important; color: inherit; }
        
        body { background: var(--bg); color: var(--text); font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; padding-bottom: 70px; }
        
        /* PC 布局容器 */
        .app-container { display: flex; max-width: 1400px; margin: 0 auto; min-height: 100vh; }
        
        /* 侧边栏 (回归 v10.0 简约风格) */
        .sidebar { width: var(--sidebar-w); position: sticky; top: 0; height: 100vh; padding: 40px 20px; display: flex; flex-direction: column; border-right: 1px solid rgba(0,0,0,0.05); background: var(--bg); z-index: 100; flex-shrink: 0; }
        .logo { font-size: 28px; font-weight: 900; color: var(--red); margin-bottom: 40px; display: flex; align-items: center; gap: 10px; padding-left: 15px; letter-spacing: -1px; }
        
        .nav-menu { display: flex; flex-direction: column; gap: 5px; flex: 1; }
        .nav-item { display: flex; align-items: center; gap: 15px; padding: 12px 20px; border-radius: 25px; font-size: 18px; color: #666; font-weight: 600; transition: 0.2s; position: relative; }
        
        /* PC 风格修复：悬停浅灰，选中变黑加粗(无背景) */
        .nav-item:hover { background: rgba(0,0,0,0.03); color: #333; }
        .nav-item.active { font-weight: 900; color: #333; background: transparent; }
        
        .nav-item svg { width: 24px; height: 24px; fill: currentColor; }
        .pc-badge { background: var(--red); color: #fff; font-size: 12px; padding: 0 6px; border-radius: 10px; position: absolute; right: 15px; font-weight: bold; }
        
        .btn-create { margin-top: 20px; background: var(--red); color: #fff; border: none; padding: 15px; border-radius: 30px; font-size: 16px; font-weight: bold; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; box-shadow: 0 4px 15px rgba(255, 36, 66, 0.3); transition: 0.2s; }
        .btn-create:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(255, 36, 66, 0.4); }

        /* 内容区 */
        .main-content { flex: 1; padding: 20px 40px; max-width: 800px; margin: 0 auto; min-width: 0; }
        
        .header-box { padding: 40px 0 20px; text-align: center; }
        .h-title { font-size: 28px; font-weight: 900; margin: 0; font-style: italic; }
        .h-title span { color: var(--red); }
        .h-desc { font-size: 13px; color: #666; margin-top: 5px; }

        .list { padding: 10px 0; }
        .item { display: flex; align-items: center; background: var(--card); margin-bottom: 15px; padding: 15px; border-radius: 16px; box-shadow: 0 2px 10px rgba(0,0,0,0.03); transition: 0.2s; border: 1px solid transparent; }
        .item:hover { transform: translateY(-3px); box-shadow: 0 8px 25px rgba(0,0,0,0.08); }

        .rank { font-size: 24px; font-weight: 900; width: 50px; text-align: center; color: #ccc; font-style: italic; }
        .item:nth-child(1) .rank { color: var(--gold); font-size: 32px; text-shadow: 0 2px 10px rgba(255, 215, 0, 0.3); }
        .item:nth-child(2) .rank { color: var(--silver); font-size: 28px; }
        .item:nth-child(3) .rank { color: var(--bronze); font-size: 26px; }

        .thumb { width: 80px; height: 80px; border-radius: 12px; object-fit: cover; background: #eee; margin-right: 20px; flex-shrink: 0; }
        .no-thumb { width: 80px; height: 80px; border-radius: 12px; display: flex; align-items: center; justify-content: center; color: #999; font-size: 12px; background: #f5f5f5; margin-right: 20px; flex-shrink: 0; }
        
        .info { flex: 1; min-width: 0; }
        .txt { font-size: 16px; line-height: 1.5; margin-bottom: 8px; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; font-weight: 500; color: #333; }
        .meta { display: flex; justify-content: space-between; align-items: center; font-size: 12px; color: #999; }
        .hot { color: var(--red); font-weight: bold; display: flex; align-items: center; gap: 4px; }
        
        /* 手机 Dock (PC默认隐藏) */
        .dock { display: none; position: fixed; bottom: 0; width: 100%; height: 55px; background: #fff; border-top: 1px solid #eee; justify-content: space-around; align-items: center; z-index: 1000; padding-bottom: env(safe-area-inset-bottom); }
        .dock-item { display: flex; flex-direction: column; align-items: center; color: #999; font-size: 10px; width: 20%; }
        .dock-item.active { color: #333; font-weight: bold; }
        .dock-item svg { width: 24px; height: 24px; fill: currentColor; margin-bottom: 2px; }
        .m-badge { position: absolute; top: -2px; right: 25%; background: var(--red); color: #fff; font-size: 9px; padding: 1px 4px; border-radius: 10px; }
        .pub-btn-m { background: var(--red); border-radius: 12px; width: 45px; height: 32px; display: flex; align-items: center; justify-content: center; color: #fff; }
        
        /* Mobile 适配 */
        @media (max-width: 900px) {
            .sidebar { display: none !important; }
            .dock { display: flex !important; }
            .main-content { padding: 0 15px; width: 100%; }
            .item { padding: 12px; }
            .thumb, .no-thumb { width: 60px; height: 60px; margin-right: 12px; }
            .rank { width: 30px; font-size: 20px; }
            .txt { font-size: 15px; }
        }
    </style>
</head>
<body>

<div class="app-container">
    <div class="sidebar">
        <div class="logo"><i class="fa-solid fa-trophy"></i> 热门榜单</div>
        <nav class="nav-menu">
            <a href="index.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg> 发现</a>
            <a href="rank.php" class="nav-item active"><svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"/></svg> 榜单</a>
            <a href="chat.php?to_id=0" class="nav-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg> 聊天</a>
            <a href="message.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z"/></svg> 消息 <?php if($unread_total>0):?><span class="pc-badge"><?=$unread_total?></span><?php endif; ?></a>
            <a href="user.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg> 我</a>
        </nav>
        <button class="btn-create" onclick="location.href='index.php'"><i class="fa-solid fa-plus"></i> 发布图文</button>
    </div>

    <div class="main-content">
        <div class="header-box">
            <h1 class="h-title">🔥 热门<span>榜单</span></h1>
            <div class="h-desc">全站最火内容实时更新</div>
        </div>

        <div class="list">
            <?php $i=1; foreach($posts as $p): 
                $imgs = json_decode(stripslashes($p['image_url']), true);
                if(!is_array($imgs)) $imgs = $p['image_url'] ? [$p['image_url']] : [];
                $cover = $imgs[0] ?? '';
            ?>
            <a href="post.php?id=<?= $p['id'] ?>" class="item">
                <div class="rank"><?= $i++ ?></div>
                <?php if($cover): ?>
                    <img src="<?= htmlspecialchars($cover) ?>" class="thumb" loading="lazy">
                <?php else: ?>
                    <div class="no-thumb"><i class="fa-solid fa-align-left" style="font-size:20px;"></i></div>
                <?php endif; ?>
                <div class="info">
                    <div class="txt"><?= htmlspecialchars($p['content']) ?></div>
                    <div class="meta">
                        <span>@<?= htmlspecialchars($p['username']) ?></span>
                        <span class="hot"><i class="fa-solid fa-fire"></i> <?= $p['likes'] ?></span>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<nav class="dock">
    <a href="index.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>首页</a>
    <a href="rank.php" class="dock-item active"><svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"/></svg>榜单</a>
    <div class="dock-item" onclick="location.href='index.php'"><div class="pub-btn-m"><i class="fa-solid fa-plus"></i></div></div>
    <a href="chat.php?to_id=0" class="dock-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg> <?php if($unread_total > 0): ?><div class="m-badge"><?= $unread_total > 99 ? '99+' : $unread_total ?></div><?php endif; ?>消息</a>
    <a href="user.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg>我</a>
</nav>

</body>
</html>