<?php
/**
 * shop.php - v24.0 多图UI美化版
 * 1. 彻底重构发布界面：支持多图预览 (UI层)
 * 2. 视觉升级：网格布局，更符合现代操作习惯
 */
require 'db.php';

$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$tabIdx = isset($_GET['tab']) ? intval($_GET['tab']) : 0; 

$token = $_COOKIE['xyb_token'] ?? '';
$user = null;
if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

// 积分商品
$sysItems = $conn->query("SELECT * FROM assets ORDER BY price ASC")->fetchAll(PDO::FETCH_ASSOC);

// 闲置商品
$sql = "SELECT p.*, u.username, u.avatar FROM products p LEFT JOIN users u ON p.user_id = u.id WHERE p.status=1";
$params = [];
if ($q) {
    $sql .= " AND (p.title LIKE ? OR p.description LIKE ?)";
    $params = ["%$q%", "%$q%"];
}
$sql .= " ORDER BY p.id DESC LIMIT 50";
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

$siteName = get_setting('site_name', 'Slice');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>商城</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --p: #ff2442; --bg: #f8f8f8; --text: #333; --yellow: #ffda44; }
        * { box-sizing: border-box; margin:0; padding:0; outline:none; -webkit-tap-highlight-color: transparent; }
        body { background: var(--bg); font-family: -apple-system, sans-serif; padding-bottom: 80px; }

        .app-container { display: flex; max-width: 1400px; margin: 0 auto; min-height: 100vh; }
        .sidebar { width: 240px; position: sticky; top: 0; height: 100vh; padding: 30px 20px; display: flex; flex-direction: column; background: var(--bg); border-right: 1px solid rgba(0,0,0,0.05); z-index: 90; }
        .logo { font-size: 26px; font-weight: 900; color: var(--p); margin-bottom: 40px; padding-left: 10px; }
        .nav-menu { flex: 1; display: flex; flex-direction: column; gap: 8px; }
        .nav-item { display: flex; align-items: center; gap: 15px; padding: 12px 15px; border-radius: 12px; font-size: 16px; color: #555; font-weight: 600; text-decoration: none; }
        .nav-item.active { font-weight: 900; color: #333; background: #fff; box-shadow: 0 2px 8px rgba(0,0,0,0.03); }
        .nav-item svg { width: 22px; height: 22px; fill: currentColor; }
        .btn-create { margin-top: 20px; background: var(--p); color: #fff; border: none; padding: 14px; border-radius: 30px; font-size: 16px; font-weight: bold; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 8px; }

        .main-content { flex: 1; min-width: 0; }

        /* 顶部 Tab */
        .shop-header { background: rgba(255,255,255,0.95); padding: 15px; position: sticky; top: 0; z-index: 80; border-bottom: 1px solid #f0f0f0; display: flex; justify-content: center; gap: 40px; backdrop-filter: blur(10px); }
        .switch-btn { font-size: 16px; color: #999; font-weight: bold; cursor: pointer; padding: 10px 5px; position: relative; }
        .switch-btn.active { color: #333; font-size: 18px; }
        .switch-btn.active::after { content:''; position:absolute; bottom:0; left:50%; transform:translateX(-50%); width:20px; height:3px; background:var(--p); border-radius:2px; }

        .shop-box { display: none; padding: 15px; }
        .shop-box.active { display: block; }

        /* 商品列表 */
        .prod-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; }
        .prod-item { background: #fff; border-radius: 8px; overflow: hidden; cursor: pointer; }
        .prod-img { width: 100%; aspect-ratio: 1; object-fit: cover; background: #f9f9f9; }
        .prod-info { padding: 10px; }
        .prod-title { font-weight: bold; font-size: 14px; margin-bottom: 6px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .prod-price { color: var(--p); font-weight: 900; font-size: 16px; }
        .prod-user { font-size: 10px; color: #999; display: flex; align-items: center; gap: 4px; margin-top: 5px; }
        .prod-avt { width: 16px; height: 16px; border-radius: 50%; }

        .sell-fab { position: fixed; bottom: 80px; right: 20px; background: var(--yellow); color: #333; padding: 10px 20px; border-radius: 30px; font-weight: bold; display: flex; align-items: center; gap: 5px; box-shadow: 0 5px 20px rgba(255, 218, 68, 0.4); cursor: pointer; z-index: 90; }

        /* 底部 Dock */
        .dock { display: none; position: fixed; bottom: 0; width: 100%; height: 55px; background: #fff; border-top: 1px solid #eee; justify-content: space-around; align-items: center; z-index: 100; padding-bottom: env(safe-area-inset-bottom); }
        .dock-item { display: flex; flex-direction: column; align-items: center; color: #999; font-size: 10px; text-decoration: none; width: 20%; }
        .dock-item.active { color: #333; font-weight: bold; }
        .dock-item svg { width: 24px; height: 24px; fill: currentColor; }

        @media (max-width: 900px) {
            .sidebar { display: none !important; }
            .dock { display: flex !important; }
        }

        /* 🔥 全新发布弹窗样式 */
        .pub-overlay { display: none; position: fixed; inset: 0; background: #fff; z-index: 9999; flex-direction: column; }
        .pub-header { padding: 15px; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #f5f5f5; }
        .pub-cancel { font-size: 16px; color: #333; cursor: pointer; }
        .pub-btn { background: var(--yellow); padding: 6px 20px; border-radius: 20px; font-weight: bold; border: none; font-size: 14px; cursor: pointer; }
        
        .pub-body { padding: 20px; overflow-y: auto; flex: 1; }
        
        /* 多图上传网格 */
        .upload-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-bottom: 20px; }
        .upload-item { aspect-ratio: 1; border-radius: 8px; overflow: hidden; position: relative; }
        .upload-item img { width: 100%; height: 100%; object-fit: cover; }
        .upload-add { background: #f5f5f5; display: flex; align-items: center; justify-content: center; color: #ccc; font-size: 30px; cursor: pointer; border: 1px dashed #ddd; aspect-ratio: 1; border-radius: 8px; }
        
        .inp-group { margin-bottom: 15px; }
        .title-inp { width: 100%; border: none; border-bottom: 1px solid #eee; padding: 15px 0; font-size: 16px; font-weight: bold; outline: none; }
        .desc-inp { width: 100%; border: none; padding: 15px 0; font-size: 15px; outline: none; min-height: 100px; resize: none; font-family: inherit; }
        .price-inp-box { display: flex; align-items: center; border-top: 1px solid #eee; padding-top: 15px; }
        .price-label { font-size: 16px; font-weight: bold; margin-right: 10px; }
        .price-inp { border: none; font-size: 20px; font-weight: 900; color: var(--p); outline: none; flex: 1; }
    </style>
</head>
<body>

<div class="app-container">
    <div class="sidebar">
        <div class="logo"><i class="fa-solid fa-shop"></i> 市集</div>
        <nav class="nav-menu">
            <a href="index.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg> 发现</a>
            <a href="shop.php" class="nav-item active"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg> 商城</a>
            <a href="chat.php?to_id=0" class="nav-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg> 聊天</a>
            <a href="message.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z"/></svg> 消息</a>
            <a href="user.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg> 我</a>
        </nav>
        <button class="btn-create" onclick="openSell()">发布闲置</button>
    </div>

    <div class="main-content">
        <div class="shop-header">
            <div class="switch-btn <?= $tabIdx==0?'active':'' ?>" onclick="sw(0)">闲置</div>
            <div class="switch-btn <?= $tabIdx==1?'active':'' ?>" onclick="sw(1)">兑换</div>
        </div>

        <div id="box-0" class="shop-box <?= $tabIdx==0?'active':'' ?>">
            <div class="prod-grid">
                <?php foreach($products as $p): ?>
                <div class="prod-item" onclick="location.href='product.php?id=<?= $p['id'] ?>'">
                    <img src="<?= $p['image_url']?:'https://ui-avatars.com/api/?name=I' ?>" class="prod-img">
                    <div class="prod-info">
                        <div class="prod-title"><?= htmlspecialchars($p['title']) ?></div>
                        <div class="prod-price">¥ <?= floatval($p['price']) ?></div>
                        <div class="prod-user">
                            <img src="<?= $p['avatar']?:'https://ui-avatars.com/api/?name=U' ?>" class="prod-avt">
                            <?= htmlspecialchars($p['username']) ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php if(empty($products)): ?><div style="text-align:center;padding:50px;color:#ccc;">暂无商品</div><?php endif; ?>
            <div class="sell-fab" onclick="openSell()"><i class="fa-solid fa-camera"></i> 卖闲置</div>
        </div>

        <div id="box-1" class="shop-box <?= $tabIdx==1?'active':'' ?>">
            <div style="background:#333;color:#ffd700;padding:20px;border-radius:12px;margin-bottom:20px;display:flex;justify-content:space-between;align-items:center;">
                <div><i class="fa-solid fa-coins"></i> 积分余额: <b><?= $user['points']??0 ?></b></div>
                <div style="font-size:12px;opacity:0.8">发帖 +10</div>
            </div>
            <div class="prod-grid" style="grid-template-columns:repeat(3,1fr)">
                <?php foreach($sysItems as $item): ?>
                <div class="prod-item" style="text-align:center;padding:15px;border:1px solid #eee;">
                    <div style="font-weight:bold;margin-bottom:5px;"><?= $item['name'] ?></div>
                    <div style="color:#f39c12;font-size:12px;margin-bottom:10px;"><i class="fa-solid fa-coins"></i> <?= $item['price'] ?></div>
                    <button onclick="buy(<?= $item['id'] ?>)" style="background:var(--p);color:#fff;border:none;padding:4px 12px;border-radius:12px;font-size:12px;">兑换</button>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<nav class="dock">
    <a href="index.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg></a>
    <a href="shop.php" class="dock-item active"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg></a>
    <div class="dock-item" onclick="openSell()"><div style="background:#ff2442;border-radius:12px;width:45px;height:32px;display:flex;align-items:center;justify-content:center;"><i class="fa-solid fa-plus" style="color:#fff"></i></div></div>
    <a href="message.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg></a>
    <a href="user.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg></a>
</nav>

<div class="pub-overlay" id="sellModal">
    <div class="pub-header">
        <span class="pub-cancel" onclick="closeSell()">取消</span>
        <span style="font-weight:bold;">发布闲置</span>
        <button class="pub-btn" onclick="doSell()">发布</button>
    </div>
    <div class="pub-body">
        <form id="sellForm">
            <div class="upload-grid" id="imgGrid">
                <label class="upload-add" id="addBtn">
                    <input type="file" name="image" accept="image/*" multiple style="display:none" onchange="handleFiles(this)">
                    <i class="fa-solid fa-camera"></i>
                </label>
            </div>
            
            <input type="text" name="title" class="title-inp" placeholder="标题 品牌型号都是买家喜欢的" required>
            <textarea name="desc" class="desc-inp" placeholder="描述一下宝贝的转手原因、入手渠道和新旧程度..."></textarea>
            
            <div class="price-inp-box">
                <span class="price-label">价格</span>
                <span style="color:var(--p);font-weight:bold;margin-right:5px;">¥</span>
                <input type="number" name="price" class="price-inp" placeholder="0.00">
            </div>
        </form>
    </div>
</div>

<script>
    function sw(idx) {
        document.querySelectorAll('.switch-btn').forEach((b,i)=>b.classList.toggle('active', i===idx));
        document.querySelectorAll('.shop-box').forEach((b,i)=>b.classList.toggle('active', i===idx));
        const fab = document.querySelector('.sell-fab');
        if(fab) fab.style.display = idx===0 ? 'flex' : 'none';
    }

    function openSell() { 
        <?php if(!$user): ?> location.href='login.php'; return; <?php endif; ?>
        document.getElementById('sellModal').style.display='flex'; 
    }
    function closeSell() { document.getElementById('sellModal').style.display='none'; }

    // 处理多图预览
    function handleFiles(inp) {
        const files = inp.files;
        if(files.length > 0) {
            // 获取 grid 和 添加按钮
            const grid = document.getElementById('imgGrid');
            const addBtn = document.getElementById('addBtn');
            
            // 简单逻辑：只预览第一张，因为后端暂只支持一张主图
            // 如果要支持多张，需要修改 submit_product.php 循环处理
            const file = files[0];
            const reader = new FileReader();
            reader.onload = function(e) {
                // 创建预览图 DOM
                const div = document.createElement('div');
                div.className = 'upload-item';
                div.innerHTML = `<img src="${e.target.result}">`;
                // 插入到添加按钮之前
                grid.insertBefore(div, addBtn);
                // 隐藏添加按钮 (暂限一张，如需多张去掉此行)
                addBtn.style.display = 'none';
            }
            reader.readAsDataURL(file);
        }
    }

    function doSell() {
        const btn = document.querySelector('.pub-btn');
        btn.innerText = '...';
        const fd = new FormData(document.getElementById('sellForm'));
        fetch('submit_product.php', { method:'POST', body:fd }).then(r=>r.json()).then(res=>{
            if(res.status==='success') location.reload();
            else { alert(res.msg); btn.innerText='发布'; }
        });
    }

    function buy(id) {
        if(!confirm('确定兑换？')) return;
        const fd = new FormData(); fd.append('action','buy'); fd.append('id',id);
        fetch('api_user.php', {method:'POST',body:fd}).then(r=>r.json()).then(res=>{
            alert(res.msg); if(res.status==='success') location.reload();
        });
    }
</script>
</body>
</html>