<?php
/**
 * submit.php - v31.0 逻辑修复版
 * 1. 修复：发布帖子被强制变成“匿名”的 BUG
 * 2. 保持：AI 自动回复触发
 */
require 'db.php';
header('Content-Type: application/json');

$token = $_COOKIE['xyb_token'] ?? '';
$user = null;
if ($token) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

if (!$user) { echo json_encode(['status'=>'error', 'msg'=>'请先登录']); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $content = trim($_POST['content'] ?? '');
    
    // 🔥🔥 核心修复：前端传 "0" 或 "1"，这里强制转为整数
    $is_anonymous = intval($_POST['is_anonymous'] ?? 0);
    
    if (empty($content) && empty($_FILES['image']['name'])) {
        echo json_encode(['status'=>'error', 'msg'=>'内容或图片不能为空']); exit;
    }

    // 图片上传逻辑
    $imagePaths = [];
    if (!empty($_FILES['image']['name'])) {
        $uploadDir = 'uploads/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        if (is_array($_FILES['image']['name'])) {
            foreach ($_FILES['image']['tmp_name'] as $key => $tmpName) {
                if ($_FILES['image']['error'][$key] === 0) {
                    $ext = pathinfo($_FILES['image']['name'][$key], PATHINFO_EXTENSION);
                    $fileName = uniqid('post_') . '.' . $ext;
                    if (move_uploaded_file($tmpName, $uploadDir . $fileName)) $imagePaths[] = $uploadDir . $fileName;
                }
            }
        } else {
            if ($_FILES['image']['error'] === 0) {
                $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
                $fileName = uniqid('post_') . '.' . $ext;
                if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir . $fileName)) $imagePaths[] = $uploadDir . $fileName;
            }
        }
    }
    
    $imgJson = !empty($imagePaths) ? json_encode($imagePaths) : null;

    try {
        $stmt = $conn->prepare("INSERT INTO posts (user_id, content, image_url, is_anonymous, created_at) VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute([$user['id'], $content, $imgJson, $is_anonymous]);
        $newPostId = $conn->lastInsertId();

        // 加分
        $conn->prepare("UPDATE users SET points = points + 10 WHERE id = ?")->execute([$user['id']]);

        // 触发 AI
        if (file_exists('ai_helper.php')) {
            require_once 'ai_helper.php';
            $aiPrompt = empty($content) ? "分享了图片" : $content;
            aiCommentPost($newPostId, $aiPrompt);
        }

        echo json_encode(['status'=>'success', 'msg'=>'发布成功，积分+10']);

    } catch (Exception $e) {
        echo json_encode(['status'=>'error', 'msg'=>'错误: ' . $e->getMessage()]);
    }
}
?>