<?php
/**
 * submit_product.php - 商品管理接口
 */
require 'db.php';
header('Content-Type: application/json');

$token = $_COOKIE['xyb_token'] ?? '';
$u = $conn->prepare("SELECT id FROM users WHERE token = ?");
$u->execute([$token]);
$me = $u->fetch();

if(!$me) { echo json_encode(['status'=>'error','msg'=>'请先登录']); exit; }
$myId = $me['id'];

$action = $_POST['action'] ?? 'publish';

try {
    // 1. 发布商品
    if ($action === 'publish') {
        $title = trim($_POST['title'] ?? '');
        $price = floatval($_POST['price'] ?? 0);
        $desc = trim($_POST['desc'] ?? '');
        $imgUrl = '';

        if(empty($title) || $price <= 0) {
            echo json_encode(['status'=>'error','msg'=>'请填写标题和价格']); exit;
        }

        if (!empty($_FILES['image']['tmp_name'])) {
            $uploadDir = 'uploads/';
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $newName = uniqid('prod_') . '.' . $ext;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir . $newName)) {
                $imgUrl = $uploadDir . $newName;
            }
        }

        $stmt = $conn->prepare("INSERT INTO products (user_id, title, price, description, image_url) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$myId, $title, $price, $desc, $imgUrl]);
        echo json_encode(['status'=>'success']);
    }

    // 2. 更新状态 (上下架)
    elseif ($action === 'update_product_status') {
        $pid = intval($_POST['id']);
        $status = intval($_POST['status']);
        // 只能改自己的
        $stmt = $conn->prepare("UPDATE products SET status = ? WHERE id = ? AND user_id = ?");
        $stmt->execute([$status, $pid, $myId]);
        echo json_encode(['status'=>'success']);
    }

    // 3. 删除商品
    elseif ($action === 'delete_product') {
        $pid = intval($_POST['id']);
        $stmt = $conn->prepare("DELETE FROM products WHERE id = ? AND user_id = ?");
        $stmt->execute([$pid, $myId]);
        echo json_encode(['status'=>'success']);
    }

} catch (Exception $e) {
    echo json_encode(['status'=>'error','msg'=>$e->getMessage()]);
}