<?php
/**
 * user.php - v27.1 逻辑修复版
 * 1. 修复顶部图标逻辑：看别人时不显示扫一扫和相机
 * 2. 修复二维码逻辑：看别人时生成对方的主页二维码
 * 3. 优化名片文案 (我的/TA的)
 */
require 'db.php';

$id = intval($_GET['id'] ?? 0);
$token = $_COOKIE['xyb_token'] ?? '';
$currentUser = null;

if ($token) {
    $u = $conn->prepare("SELECT * FROM users WHERE token = ?");
    $u->execute([$token]);
    $currentUser = $u->fetch(PDO::FETCH_ASSOC);
}

// 确定当前查看的目标用户 ($viewedUser)
if ($id == 0 && $currentUser) {
    $viewedUser = $currentUser;
    $isMe = true;
} else {
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$id]);
    $viewedUser = $stmt->fetch(PDO::FETCH_ASSOC);
    // 判断是否是自己
    $isMe = ($currentUser && isset($viewedUser['id']) && $currentUser['id'] == $viewedUser['id']);
}

if (!$viewedUser) { header("Location: login.php"); exit; }

$viewedUserId = $viewedUser['id'];

// --- 1. 数据统计 ---
try {
    $stats = [
        'posts' => $conn->query("SELECT count(*) FROM posts WHERE user_id = $viewedUserId")->fetchColumn(),
        'following' => $conn->query("SELECT count(*) FROM follows WHERE follower_id = $viewedUserId")->fetchColumn(),
        'followers' => $conn->query("SELECT count(*) FROM follows WHERE following_id = $viewedUserId")->fetchColumn(),
        'likes_got' => $conn->query("SELECT SUM(likes) FROM posts WHERE user_id = $viewedUserId")->fetchColumn() ?: 0
    ];
} catch (Exception $e) { $stats = ['posts'=>0,'following'=>0,'followers'=>0,'likes_got'=>0]; }

// --- 2. 背景与称号 ---
$bgStyle = 'background-color: #333;'; 
$currTitle = null;

if (!empty($viewedUser['background'])) {
    $bgStyle = "background-image: url('{$viewedUser['background']}'); background-size: cover; background-position: center;";
} else {
    try {
        $stmt = $conn->query("SELECT a.value FROM user_assets ua LEFT JOIN assets a ON ua.asset_id = a.id WHERE ua.user_id=$viewedUserId AND ua.is_equipped=1 AND a.type='bg'");
        $equipBg = $stmt->fetchColumn();
        if (!empty($equipBg)) {
            $equipBg = (string)$equipBg;
            if (strpos($equipBg, 'http') === 0 || strpos($equipBg, '/') === 0) {
                $bgStyle = "background-image: url('$equipBg'); background-size: cover; background-position: center;";
            } else {
                $bgStyle = "background: $equipBg;";
            }
        }
    } catch(Exception $e){}
}

try {
    $currTitle = $conn->query("SELECT a.value, a.style FROM user_assets ua LEFT JOIN assets a ON ua.asset_id = a.id WHERE ua.user_id=$viewedUserId AND ua.is_equipped=1 AND a.type='title'")->fetch(PDO::FETCH_ASSOC);
} catch(Exception $e){}

// --- 3. 关注状态 ---
$followState = 'none'; 
$btnText = '关注';
if (!$isMe && $currentUser) {
    $checkMe = $conn->query("SELECT id FROM follows WHERE follower_id={$currentUser['id']} AND following_id=$viewedUserId")->fetch();
    if ($checkMe) {
        $followState = 'followed';
        $btnText = '已关注';
        $checkHim = $conn->query("SELECT id FROM follows WHERE follower_id=$viewedUserId AND following_id={$currentUser['id']}")->fetch();
        if ($checkHim) {
            $followState = 'mutual';
            $btnText = '互相关注';
        }
    }
}

// --- 4. 数据列表 ---
$posts_pub = $conn->query("SELECT * FROM posts WHERE user_id = $viewedUserId ORDER BY id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
$posts_liked = $conn->query("SELECT p.*, u.username, u.avatar FROM posts p JOIN post_likes pl ON p.id = pl.post_id LEFT JOIN users u ON p.user_id = u.id WHERE pl.user_id = $viewedUserId ORDER BY pl.id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);

$myAssets = [];
if ($isMe) {
    try {
        $myAssets = $conn->query("SELECT ua.id as ua_id, ua.is_equipped, a.* FROM user_assets ua LEFT JOIN assets a ON ua.asset_id = a.id WHERE ua.user_id=$viewedUserId ORDER BY ua.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
    } catch(Exception $e) {}
}

$siteName = get_setting('site_name', 'Slice');

// 🔥 核心：生成当前查看页面（对方）的链接
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$shareUrl = "$protocol://{$_SERVER['HTTP_HOST']}/user.php?id={$viewedUserId}";
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?= htmlspecialchars($viewedUser['username']) ?>的主页</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        :root { --p: #ff2442; --bg: #fff; --gray-bg: #f8f8f8; }
        * { box-sizing: border-box; margin:0; padding:0; outline:none; -webkit-tap-highlight-color: transparent; }
        body { background: var(--gray-bg); font-family: -apple-system, sans-serif; padding-bottom: 80px; }
        
        .app-container { display: flex; max-width: 1400px; margin: 0 auto; min-height: 100vh; }
        .sidebar { width: 240px; position: sticky; top: 0; height: 100vh; padding: 30px 20px; display: flex; flex-direction: column; border-right: 1px solid rgba(0,0,0,0.05); background: #fff; z-index: 90; flex-shrink: 0; }
        .logo { font-size: 26px; font-weight: 900; color: var(--p); margin-bottom: 40px; display: flex; align-items: center; gap: 10px; padding-left: 10px; }
        .nav-menu { flex: 1; display: flex; flex-direction: column; gap: 8px; }
        .nav-item { display: flex; align-items: center; gap: 15px; padding: 12px 15px; border-radius: 12px; font-size: 16px; color: #555; font-weight: 600; text-decoration: none; }
        .nav-item.active { font-weight: 900; color: #333; background: #f5f5f5; }
        .nav-item svg { width: 22px; height: 22px; fill: currentColor; }
        
        .main-content { flex: 1; min-width: 0; display: flex; justify-content: center; }
        .profile-wrapper { width: 100%; max-width: 700px; background: #fff; min-height: 100vh; position: relative; }

        .user-header { 
            position: relative; height: 260px; 
            <?= $bgStyle ?> 
            display: flex; flex-direction: column; justify-content: flex-end; padding: 20px;
            transition: 0.3s;
        }
        .user-header::after { content:''; position: absolute; inset:0; background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.8)); pointer-events: none; }

        /* 顶部导航 */
        .nav-float { 
            position: absolute; top: 0; left: 0; width: 100%; padding: 15px; z-index: 10; 
            display: flex; justify-content: space-between; align-items: flex-start; 
        }
        .nav-icon { 
            color: #fff; font-size: 20px; cursor: pointer; text-shadow: 0 1px 3px rgba(0,0,0,0.5); 
            padding: 5px; transition: 0.2s; 
        }
        .nav-icon:active { transform: scale(0.9); }
        .top-right-icons { display: flex; align-items: center; gap: 15px; }

        .u-info { position: relative; z-index: 2; display: flex; align-items: flex-end; gap: 15px; transform: translateY(15px); }
        .u-avatar { width: 84px; height: 84px; border-radius: 50%; border: 3px solid #fff; object-fit: cover; background: #fff; }
        .u-text { flex: 1; margin-bottom: 10px; color: #fff; text-shadow: 0 2px 4px rgba(0,0,0,0.5); }
        .u-name { font-size: 22px; font-weight: 900; margin-bottom: 4px; display: flex; align-items: center; gap: 8px; }
        .title-badge { font-size: 10px; padding: 2px 6px; border-radius: 6px; text-shadow: none; font-weight: bold; background: rgba(255,255,255,0.2); backdrop-filter: blur(2px); border: 1px solid rgba(255,255,255,0.3); }
        .u-id { font-size: 12px; opacity: 0.9; font-family: monospace; }

        .action-row { display: flex; justify-content: flex-end; padding: 15px 20px; margin-top: 15px; gap: 10px; }
        .btn { padding: 6px 20px; border-radius: 20px; font-size: 14px; font-weight: bold; cursor: pointer; border: 1px solid #ddd; background: #fff; color: #333; text-decoration: none; display: flex; align-items: center; justify-content: center; }
        .btn-follow { background: var(--p); color: #fff; border: none; box-shadow: 0 4px 10px rgba(255, 36, 66, 0.3); }
        .btn-follow.followed { background: #eee; color: #666; border: 1px solid #ddd; box-shadow: none; }

        .stats-row { display: flex; gap: 30px; padding: 0 20px 20px; }
        .stat-item { font-size: 14px; color: #666; }
        .stat-num { font-weight: 900; color: #000; font-size: 16px; margin-right: 4px; }

        .tabs { display: flex; background: #fff; border-bottom: 1px solid #eee; position: sticky; top: 0; z-index: 10; margin-top: 10px; }
        .tab { flex: 1; text-align: center; padding: 15px 0; font-size: 15px; color: #999; font-weight: 600; cursor: pointer; }
        .tab.active { color: #333; font-weight: 900; border-bottom: 2px solid var(--p); }

        .tab-content { display: none; padding: 5px; min-height: 300px; }
        .tab-content.active { display: block; }

        .grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 5px; }
        .post-item { aspect-ratio: 3/4; background: #f9f9f9; position: relative; overflow: hidden; cursor: pointer; }
        .post-item img { width: 100%; height: 100%; object-fit: cover; }
        .text-cover { width:100%; height:100%; display:flex; align-items:center; justify-content:center; padding:10px; text-align:center; color:#fff; font-weight:bold; font-size:12px; background:linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%); }

        .bag-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; padding: 10px; }
        .bag-item { background: #fff; border-radius: 12px; padding: 15px 10px; text-align: center; border: 1px solid #eee; cursor: pointer; transition: 0.2s; position: relative; }
        .bag-item:hover { transform: translateY(-2px); box-shadow: 0 5px 10px rgba(0,0,0,0.05); }
        .bag-item.equipped { border-color: var(--p); background: #fff5f5; }
        .bag-item.equipped::after { content:'使用中'; position:absolute; top:5px; right:5px; font-size:10px; background:var(--p); color:#fff; padding:2px 4px; border-radius:4px; }
        .preview-box { height: 50px; display: flex; align-items: center; justify-content: center; margin-bottom: 10px; }
        .bag-name { font-size: 13px; font-weight: bold; color: #333; }

        .empty-state { padding: 50px 0; text-align: center; color: #ccc; width: 100%; }
        .empty-state i { font-size: 40px; margin-bottom: 10px; color: #ddd; }

        .dock { display: none; position: fixed; bottom: 0; width: 100%; height: 55px; background: #fff; border-top: 1px solid #eee; justify-content: space-around; align-items: center; z-index: 100; }
        .dock-item { display: flex; flex-direction: column; align-items: center; color: #999; font-size: 10px; text-decoration: none; width: 20%; }
        .dock-item.active { color: #333; font-weight: bold; }
        .dock-item svg { width: 24px; height: 24px; fill: currentColor; margin-bottom: 2px; }

        @media (max-width: 900px) {
            .sidebar { display: none !important; }
            .dock { display: flex !important; }
            .profile-wrapper { border: none; max-width: 100%; }
        }

        /* 名片弹窗 */
        .qr-overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.6); z-index: 999; align-items: center; justify-content: center; backdrop-filter: blur(5px); }
        .qr-card { background: #fff; width: 80%; max-width: 320px; border-radius: 24px; padding: 30px 20px; text-align: center; position: relative; box-shadow: 0 10px 40px rgba(0,0,0,0.2); animation: popIn 0.3s; }
        .qr-card .q-avt { width: 60px; height: 60px; border-radius: 50%; margin-bottom: 10px; border: 2px solid #fff; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .qr-card .q-name { font-weight: 900; font-size: 18px; color: #333; margin-bottom: 5px; }
        .qr-card .q-desc { font-size: 12px; color: #999; margin-bottom: 20px; }
        .qr-code-box { background: #f0f0f0; padding: 10px; border-radius: 12px; display: inline-block; margin-bottom: 20px; }
        .qr-btn { background: #f5f5f5; color: #333; border: none; padding: 10px 30px; border-radius: 20px; font-weight: bold; font-size: 14px; cursor: pointer; width: 100%; }
        .qr-close { position: absolute; top: 15px; right: 15px; color: #ccc; font-size: 20px; cursor: pointer; }
        
        /* 扫码界面 */
        .scan-box { width:100%; max-width:400px; background:#000; border-radius:12px; overflow:hidden; position:relative; }
        #reader { width:100%; }
        .scan-close-btn { position:absolute; bottom:20px; left:50%; transform:translateX(-50%); background:rgba(255,255,255,0.2); color:#fff; border:1px solid rgba(255,255,255,0.3); padding:8px 20px; border-radius:20px; cursor:pointer; font-size:14px; z-index:10; }
        
        @keyframes popIn { from{transform:scale(0.8);opacity:0} to{transform:scale(1);opacity:1} }
    </style>
</head>
<body>

<div class="app-container">
    <div class="sidebar">
        <div class="logo"><i class="fa-solid fa-layer-group"></i> <?= htmlspecialchars($siteName) ?></div>
        <nav class="nav-menu">
            <a href="index.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg> 发现</a>
            <a href="shop.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg> 商城</a>
            <a href="chat.php?to_id=0" class="nav-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg> 聊天</a>
            <a href="message.php" class="nav-item"><svg viewBox="0 0 24 24"><path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z"/></svg> 消息</a>
            <a href="user.php" class="nav-item active"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg> 我</a>
        </nav>
    </div>

    <div class="main-content">
        <div class="profile-wrapper">
            <div class="user-header">
                <div class="nav-float">
                    <i class="fa-solid fa-chevron-left nav-icon" onclick="location.href='index.php'"></i>
                    
                    <div class="top-right-icons">
                        <?php if($isMe): ?>
                            <label class="nav-icon" title="上传背景">
                                <i class="fa-solid fa-camera"></i>
                                <input type="file" style="display:none" onchange="uploadBg(this)">
                            </label>
                        <?php endif; ?>
                        
                        <i class="fa-solid fa-qrcode nav-icon" onclick="showQr()" title="二维码名片"></i>
                        
                        <?php if($isMe): ?>
                            <i class="fa-solid fa-expand nav-icon" onclick="openScanner()" title="扫一扫"></i>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="u-info">
                    <img src="<?= $viewedUser['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="u-avatar">
                    <div class="u-text">
                        <div class="u-name">
                            <?= htmlspecialchars($viewedUser['username']) ?>
                            <?php if($currTitle): ?>
                                <span class="title-badge" style="<?= $currTitle['style'] ?>"><?= $currTitle['value'] ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="u-id">UID: <?= $viewedUser['id'] ?> | <?= htmlspecialchars($viewedUser['city'] ?? '未知') ?></div>
                    </div>
                </div>
            </div>

            <div class="action-row">
                <?php if($isMe): ?>
                    <a href="shop.php" class="btn"><i class="fa-solid fa-shirt"></i> 商城</a>
                    <button class="btn" onclick="location.href='edit_profile.php'">编辑资料</button>
                <?php else: ?>
                    <button class="btn btn-follow <?= $followState!='none'?'followed':'' ?>" id="followBtn" onclick="toggleFollow()">
                        <?= $btnText ?>
                    </button>
                    <a href="chat.php?to_id=<?= $viewedUser['id'] ?>" class="btn"><i class="fa-regular fa-envelope"></i> 私信</a>
                <?php endif; ?>
            </div>

            <div class="stats-row">
                <div class="stat-item"><span class="stat-num"><?= $stats['likes_got'] ?></span>获赞</div>
                <div class="stat-item"><span class="stat-num"><?= $stats['following'] ?></span>关注</div>
                <div class="stat-item"><span class="stat-num"><?= $stats['followers'] ?></span>粉丝</div>
            </div>

            <div style="padding:0 20px 20px; font-size:14px; color:#333; line-height:1.5;">
                <?= nl2br(htmlspecialchars($viewedUser['bio'] ?? '这个人很懒，什么都没写...')) ?>
            </div>

            <div class="tabs">
                <div class="tab active" onclick="switchTab(0)">笔记</div>
                <div class="tab" onclick="switchTab(1)">赞过</div>
                <?php if($isMe): ?><div class="tab" onclick="switchTab(2)">背包</div><?php endif; ?>
            </div>

            <div id="panel-0" class="tab-content active">
                <?php if(empty($posts_pub)): ?>
                    <div class="empty-state"><i class="fa-regular fa-folder-open"></i><br>暂无发布</div>
                <?php else: ?>
                    <div class="grid">
                        <?php foreach($posts_pub as $p): 
                            $imgs = json_decode(stripslashes($p['image_url'] ?? ''), true);
                            if(!is_array($imgs)) $imgs = (!empty($p['image_url']) && $p['image_url']!='null') ? [$p['image_url']] : [];
                            $cover = $imgs[0] ?? '';
                        ?>
                        <div class="post-item" onclick="location.href='post.php?id=<?= $p['id'] ?>'">
                            <?php if($cover): ?>
                                <img src="<?= htmlspecialchars($cover) ?>">
                            <?php else: ?>
                                <div class="text-cover"><span><?= htmlspecialchars(mb_substr($p['content'],0,10)) ?></span></div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <div id="panel-1" class="tab-content">
                <?php if(empty($posts_liked)): ?>
                    <div class="empty-state"><i class="fa-regular fa-heart"></i><br>暂无赞过</div>
                <?php else: ?>
                    <div class="grid">
                        <?php foreach($posts_liked as $p): 
                            $imgs = json_decode(stripslashes($p['image_url'] ?? ''), true);
                            if(!is_array($imgs)) $imgs = (!empty($p['image_url']) && $p['image_url']!='null') ? [$p['image_url']] : [];
                            $cover = $imgs[0] ?? '';
                        ?>
                        <div class="post-item" onclick="location.href='post.php?id=<?= $p['id'] ?>'">
                            <?php if($cover): ?>
                                <img src="<?= htmlspecialchars($cover) ?>">
                            <?php else: ?>
                                <div class="text-cover" style="background:#ddd;color:#666;"><span><?= htmlspecialchars(mb_substr($p['content'],0,10)) ?></span></div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($isMe): ?>
            <div id="panel-2" class="tab-content">
                <?php if(empty($myAssets)): ?>
                    <div class="empty-state"><i class="fa-solid fa-box-open"></i><br>背包空空<br><a href="shop.php?tab=1" style="color:var(--p)">去兑换</a></div>
                <?php else: ?>
                    <div class="bag-grid">
                        <?php foreach($myAssets as $item): ?>
                        <div class="bag-item <?= $item['is_equipped']?'equipped':'' ?>" onclick="equip(<?= $item['ua_id'] ?>)">
                            <div class="preview-box">
                                <?php $val=$item['value']??''; if($item['type']=='title'): ?>
                                    <span style="font-size:12px;padding:2px 6px;border-radius:4px;<?= $item['style'] ?>"><?= $val ?></span>
                                <?php else: ?>
                                    <?php if(strpos((string)$val,'http')===0): ?>
                                        <img src="<?= $val ?>" style="width:100%;height:40px;object-fit:cover;border-radius:4px;">
                                    <?php else: ?>
                                        <div style="width:40px;height:40px;border-radius:50%;background:<?= $val ?>"></div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <div class="bag-name"><?= $item['name'] ?></div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

        </div>
    </div>
</div>

<nav class="dock">
    <a href="index.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg></a>
    <a href="shop.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M4 6h16v2H4zm2 4h12v12H6zm2 2v8h2v-8zm4 0v8h2v-8z"/></svg></a>
    <div class="dock-item" onclick="location.href='index.php?openPub=1'"><div style="background:#ff2442;border-radius:12px;width:45px;height:32px;display:flex;align-items:center;justify-content:center;"><i class="fa-solid fa-plus" style="color:#fff"></i></div></div>
    <a href="message.php" class="dock-item"><svg viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"/></svg></a>
    <a href="user.php" class="dock-item active"><svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg></a>
</nav>

<div class="qr-overlay" id="qrModal" onclick="if(event.target===this) this.style.display='none'">
    <div class="qr-card">
        <i class="fa-solid fa-xmark qr-close" onclick="document.getElementById('qrModal').style.display='none'"></i>
        <img src="<?= $viewedUser['avatar'] ?: 'https://ui-avatars.com/api/?name=U' ?>" class="q-avt">
        <div class="q-name"><?= htmlspecialchars($viewedUser['username']) ?></div>
        <div class="q-desc">
            <?= $isMe ? '扫描二维码，添加我为好友' : '扫描二维码，关注TA' ?>
        </div>
        <div class="qr-code-box" id="qrcode"></div>
        <button class="qr-btn" onclick="copyLink()">复制主页链接</button>
    </div>
</div>

<div class="qr-overlay" id="scanModal" style="display:none;background:#000;">
    <div class="scan-box">
        <div id="reader"></div>
        <div class="scan-close-btn" onclick="closeScanner()">关闭摄像头</div>
    </div>
</div>

<script>
    function switchTab(idx) {
        document.querySelectorAll('.tab').forEach((t, i) => t.classList.toggle('active', i===idx));
        document.querySelectorAll('.tab-content').forEach((c, i) => {
            if(i===idx) c.classList.add('active'); else c.classList.remove('active');
        });
    }

    function toggleFollow() {
        const btn = document.getElementById('followBtn');
        const fd = new FormData(); fd.append('action', 'follow'); fd.append('id', <?= $viewedUserId ?>);
        fetch('api.php', { method: 'POST', body: fd }).then(r => r.json()).then(res => {
            if(res.status === 'success') {
                if(res.type === 'followed') { btn.classList.add('followed'); btn.innerText = res.label; } 
                else { btn.classList.remove('followed'); btn.innerText = '关注'; }
            } else alert(res.msg);
        });
    }
    
    function equip(uaId) {
        const fd = new FormData(); fd.append('action', 'equip'); fd.append('ua_id', uaId);
        fetch('api_user.php', { method: 'POST', body: fd }).then(r => r.json()).then(res => {
            if(res.status==='success') location.reload();
        });
    }

    function uploadBg(input) {
        if (!input.files || !input.files[0]) return;
        const fd = new FormData(); fd.append('action', 'upload_bg'); fd.append('image', input.files[0]);
        document.querySelector('.user-header').style.opacity = '0.5';
        fetch('api_user.php', { method: 'POST', body: fd }).then(r => r.json()).then(res => {
            if(res.status === 'success') location.reload();
            else { alert(res.msg); document.querySelector('.user-header').style.opacity = '1'; }
        });
    }

    // 二维码生成
    let qrGenerated = false;
    function showQr() {
        document.getElementById('qrModal').style.display = 'flex';
        // 每次打开都重新生成，防止切换用户数据错误 (虽然这里是MPA，但为了稳健)
        document.getElementById("qrcode").innerHTML = ""; 
        new QRCode(document.getElementById("qrcode"), {
            text: "<?= $shareUrl ?>",
            width: 160, height: 160,
            colorDark : "#000000", colorLight : "#f0f0f0",
            correctLevel : QRCode.CorrectLevel.H
        });
    }

    // 扫码逻辑
    let html5QrCode;
    function openScanner() {
        document.getElementById('scanModal').style.display = 'flex';
        html5QrCode = new Html5Qrcode("reader");
        const config = { fps: 10, qrbox: { width: 250, height: 250 } };
        
        html5QrCode.start({ facingMode: "environment" }, config, onScanSuccess)
        .catch(err => {
            alert("无法启动摄像头，请检查权限 (需HTTPS)");
            closeScanner();
        });
    }

    function onScanSuccess(decodedText) {
        closeScanner();
        if(decodedText.indexOf('user.php') !== -1) {
            window.location.href = decodedText;
        } else {
            alert("扫描结果: " + decodedText);
        }
    }

    function closeScanner() {
        if(html5QrCode) {
            html5QrCode.stop().then(() => {
                document.getElementById('scanModal').style.display = 'none';
                html5QrCode.clear();
            }).catch(err => { document.getElementById('scanModal').style.display = 'none'; });
        } else {
            document.getElementById('scanModal').style.display = 'none';
        }
    }

    function copyLink() {
        const url = "<?= $shareUrl ?>";
        if (navigator.clipboard) {
            navigator.clipboard.writeText(url).then(() => alert('链接已复制'));
        } else {
            const input = document.createElement('input');
            input.value = url;
            document.body.appendChild(input);
            input.select();
            document.execCommand('copy');
            document.body.removeChild(input);
            alert('链接已复制');
        }
    }
</script>
</body>
</html>